/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.browser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.version.Version;
import com.helger.useragent.browser.EBrowserType;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BrowserInfo
implements IHasDisplayText,
Serializable {
    public static final BrowserInfo IS_IT_NOT = new BrowserInfo();
    private final EBrowserType m_eBrowserType;
    private final Version m_aVersion;

    protected BrowserInfo() {
        this.m_eBrowserType = null;
        this.m_aVersion = new Version(0);
    }

    public BrowserInfo(@Nonnull EBrowserType eBrowserType, @Nonnull Version version) {
        this.m_eBrowserType = ValueEnforcer.notNull(eBrowserType, "BrowserType");
        this.m_aVersion = ValueEnforcer.notNull(version, "Version");
    }

    public final boolean isIt() {
        return this.m_eBrowserType != null;
    }

    public final boolean isItNot() {
        return this.m_eBrowserType == null;
    }

    @Nullable
    public final EBrowserType getBrowserType() {
        return this.m_eBrowserType;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_eBrowserType == null ? null : this.m_eBrowserType.getDisplayText(locale) + " " + this.m_aVersion.getAsString();
    }

    @Nonnull
    public final Version getVersion() {
        return this.m_aVersion;
    }

    public String toString() {
        if (this.isItNot()) {
            return new ToStringGenerator(null).append("isIt", "not").getToString();
        }
        return new ToStringGenerator(null).appendIfNotNull("type", this.m_eBrowserType).appendIfNotNull("version", this.m_aVersion).getToString();
    }
}

