/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.codec.Base32Codec;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.dns.naptr.NaptrResolver;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.smpclient.url.IBDXLURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xbill.DNS.TextParseException;

@ThreadSafe
public abstract class AbstractBDXLURLProvider
implements IBDXLURLProvider {
    public static final boolean DEFAULT_USE_DNS_CACHE = true;
    public static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    public static final Locale URL_LOCALE = Locale.US;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bLowercaseValueBeforeHashing = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bAddIdentifierSchemeToZone = true;
    @GuardedBy(value="m_aRWLock")
    private String m_sNAPTRServiceName = "not-set";
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseDNSCache = true;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, String> m_aDNSCache = new CommonsHashMap<String, String>();
    private final ICommonsList<InetAddress> m_aCustomDNSServers = new CommonsArrayList<InetAddress>();

    public final boolean isLowercaseValueBeforeHashing() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bLowercaseValueBeforeHashing);
    }

    public final void setLowercaseValueBeforeHashing(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bLowercaseValueBeforeHashing = bl;
            return this.m_bLowercaseValueBeforeHashing;
        });
    }

    public final boolean isAddIdentifierSchemeToZone() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bAddIdentifierSchemeToZone);
    }

    public final void setAddIdentifierSchemeToZone(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bAddIdentifierSchemeToZone = bl;
            return this.m_bAddIdentifierSchemeToZone;
        });
    }

    @Nonnull
    @Nonempty
    public final String getNAPTRServiceName() {
        return this.m_aRWLock.readLockedGet(() -> this.m_sNAPTRServiceName);
    }

    public final void setNAPTRServiceName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "NAPTRServiceName");
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_sNAPTRServiceName = string;
            return this.m_sNAPTRServiceName;
        });
    }

    public final boolean isUseDNSCache() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseDNSCache);
    }

    public final void setUseDNSCache(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bUseDNSCache = bl;
            return this.m_bUseDNSCache;
        });
    }

    public final void clearDNSCache() {
        this.m_aRWLock.writeLocked(this.m_aDNSCache::clear);
    }

    @Nullable
    public final String getDNSCacheEntry(@Nullable String string) {
        return StringHelper.hasText(string) ? this.m_aRWLock.readLockedGet(() -> (String)this.m_aDNSCache.get(string)) : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, String> getAllDNSCacheEntries() {
        return this.m_aRWLock.readLockedGet(this.m_aDNSCache::getClone);
    }

    public final void addDNSCacheEntries(@Nullable Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.putAll(map));
        }
    }

    public final void addDNSCacheEntry(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        this.m_aRWLock.writeLockedGet(() -> this.m_aDNSCache.put(string, string2));
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<InetAddress> customDNSServers() {
        return this.m_aCustomDNSServers;
    }

    @Nonnull
    public static String getHashValueStringRepresentation(@Nonnull String string) {
        byte[] byArray = MessageDigestValue.create(string.getBytes(URL_CHARSET), EMessageDigestAlgorithm.SHA_256).bytes();
        return new Base32Codec().setAddPaddding(false).getEncodedAsString(byArray, StandardCharsets.ISO_8859_1);
    }

    @Nonnull
    protected static String internalGetDNSName(@Nonnull IParticipantIdentifier iParticipantIdentifier, boolean bl, boolean bl2, @Nullable String string) {
        String string2;
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantIdentifier");
        if (StringHelper.hasText(string)) {
            ValueEnforcer.isTrue(StringHelper.endsWith((CharSequence)string, '.'), () -> "if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2 = bl2 ? iParticipantIdentifier.getValue() : iParticipantIdentifier.getURIEncoded();
        if (bl) {
            string2 = string2.toLowerCase(URL_LOCALE);
        }
        stringBuilder.append(AbstractBDXLURLProvider.getHashValueStringRepresentation(string2)).append('.');
        if (iParticipantIdentifier.hasScheme() && bl2) {
            string2 = iParticipantIdentifier.getScheme();
            if (bl) {
                string2 = string2.toLowerCase(URL_LOCALE);
            }
            stringBuilder.append(string2).append('.');
        }
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws PeppolDNSResolutionException {
        return AbstractBDXLURLProvider.internalGetDNSName(iParticipantIdentifier, this.isLowercaseValueBeforeHashing(), this.isAddIdentifierSchemeToZone(), string);
    }

    @Override
    @Nonnull
    public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws PeppolDNSResolutionException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantIdentifier");
        if (StringHelper.hasText(string) && !StringHelper.endsWith((CharSequence)string, '.')) {
            throw new PeppolDNSResolutionException("if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        String string2 = this.getDNSNameOfParticipant(iParticipantIdentifier, string);
        boolean bl = this.isUseDNSCache();
        try {
            String string3;
            String string4 = string3 = bl ? this.getDNSCacheEntry(string2) : null;
            if (string3 == null) {
                String string5 = this.getNAPTRServiceName();
                string3 = NaptrResolver.resolveFromUNAPTR(string2, this.customDNSServers(), string5);
                if (string3 == null) {
                    throw new PeppolDNSResolutionException("Failed to resolve '" + string2 + "' and service '" + string5 + "' to a DNS U-NAPTR");
                }
                if (bl) {
                    this.addDNSCacheEntry(string2, string3);
                }
            }
            try {
                return new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new PeppolDNSResolutionException("Error building SMP URI from string '" + string3 + "'", uRISyntaxException);
            }
        }
        catch (TextParseException textParseException) {
            throw new PeppolDNSResolutionException("Failed to parse '" + string2 + "'", textParseException);
        }
    }
}

