/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLFactory;
import com.helger.xml.XMLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Immutable
public final class W3CEndpointReferenceHelper {
    private static final W3CEndpointReferenceHelper s_aInstance = new W3CEndpointReferenceHelper();

    private W3CEndpointReferenceHelper() {
    }

    @Nonnull
    public static W3CEndpointReference createEndpointReference(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Address");
        return new W3CEndpointReferenceBuilder().address(string).build();
    }

    @Nonnull
    public static W3CEndpointReference createEndpointReference(@Nonnull String string, @Nonnull Iterable<Element> iterable) {
        ValueEnforcer.notNull(string, "Address");
        W3CEndpointReferenceBuilder w3CEndpointReferenceBuilder = new W3CEndpointReferenceBuilder().address(string);
        for (Element element : iterable) {
            w3CEndpointReferenceBuilder = w3CEndpointReferenceBuilder.referenceParameter(element);
        }
        return w3CEndpointReferenceBuilder.build();
    }

    @Nonnull
    private static Element _convertReferenceToXML(@Nonnull W3CEndpointReference w3CEndpointReference) {
        Document document = XMLFactory.newDocument();
        DOMResult dOMResult = new DOMResult(document);
        w3CEndpointReference.writeTo(dOMResult);
        return document.getDocumentElement();
    }

    @Nullable
    public static String getAddress(@Nonnull W3CEndpointReference w3CEndpointReference) {
        ValueEnforcer.notNull(w3CEndpointReference, "EndpointReference");
        Element element = XMLHelper.getFirstChildElementOfName(W3CEndpointReferenceHelper._convertReferenceToXML(w3CEndpointReference), "Address");
        return element == null ? null : element.getTextContent();
    }

    @Nullable
    public static ICommonsList<Element> getReferenceParameters(@Nonnull W3CEndpointReference w3CEndpointReference) {
        ValueEnforcer.notNull(w3CEndpointReference, "EndpointReference");
        Element element = XMLHelper.getFirstChildElementOfName(W3CEndpointReferenceHelper._convertReferenceToXML(w3CEndpointReference), "ReferenceParameters");
        if (element == null) {
            return null;
        }
        return new CommonsArrayList<ChildElementIterator>(new ChildElementIterator(element));
    }

    @Nullable
    public static Element getReferenceParameter(@Nonnull W3CEndpointReference w3CEndpointReference, @Nonnegative int n) {
        ValueEnforcer.notNull(w3CEndpointReference, "EndpointReference");
        ValueEnforcer.isGE0(n, "Index");
        ICommonsList<Element> iCommonsList = W3CEndpointReferenceHelper.getReferenceParameters(w3CEndpointReference);
        return iCommonsList == null ? null : (Element)iCommonsList.getAtIndex(n);
    }
}

