/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.httpclient.AbstractSMPResponseHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPHttpResponseHandlerUnsigned<T>
extends AbstractSMPResponseHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPHttpResponseHandlerUnsigned.class);
    private final GenericJAXBMarshaller<T> m_aMarshaller;

    public SMPHttpResponseHandlerUnsigned(@Nonnull GenericJAXBMarshaller<T> genericJAXBMarshaller) {
        this.m_aMarshaller = ValueEnforcer.notNull(genericJAXBMarshaller, "Marshaller");
    }

    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws SMPClientBadResponseException, IOException {
        Object JAXBTYPE = this.m_aMarshaller.read(httpEntity.getContent());
        if (JAXBTYPE == null) {
            throw new SMPClientBadResponseException("Malformed XML document returned from SMP server");
        }
        return (T)JAXBTYPE;
    }
}

