/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.httpclient.HttpClientManager;
import com.helger.smpclient.config.SMPClientConfiguration;
import com.helger.smpclient.exception.SMPClientBadRequestException;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.exception.SMPClientUnauthorizedException;
import com.helger.smpclient.httpclient.SMPHttpClientSettings;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericSMPClient<IMPLTYPE extends AbstractGenericSMPClient<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 10000;
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    public static final boolean DEFAULT_XML_SCHEMA_VALIDATION = true;
    public static final ContentType CONTENT_TYPE_TEXT_XML = ContentType.create(CMimeType.TEXT_XML.getAsString(), StandardCharsets.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenericSMPClient.class);
    private static final KeyStore DEFAULT_TRUST_STORE = SMPClientConfiguration.loadTrustStore();
    private final String m_sSMPHost;
    private boolean m_bVerifySignature = true;
    private KeyStore m_aTrustStore = DEFAULT_TRUST_STORE;
    private boolean m_bFollowSMPRedirects = true;
    private boolean m_bXMLSchemaValidation = true;
    private final SMPHttpClientSettings m_aHttpClientSettings = new SMPHttpClientSettings();

    public AbstractGenericSMPClient(@Nonnull URI uRI) {
        String string;
        ValueEnforcer.notNull(uRI, "SMPHost");
        if (!"http".equals(uRI.getScheme()) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("SMP URI " + uRI + " does not use the expected http scheme!");
        }
        if (uRI.getPort() != 80 && uRI.getPort() != -1 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("SMP URI " + uRI + " is not running on port 80!");
        }
        this.m_sSMPHost = (string = uRI.toString()).endsWith("/") ? string : string + '/';
    }

    @Nonnull
    public final String getSMPHostURI() {
        return this.m_sSMPHost;
    }

    @Nonnull
    @ReturnsMutableObject
    public final SMPHttpClientSettings httpClientSettings() {
        return this.m_aHttpClientSettings;
    }

    @Nullable
    @Deprecated
    public final HttpHost getProxy() {
        return this.m_aHttpClientSettings.getProxyHost();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setProxy(@Nullable HttpHost httpHost) {
        this.m_aHttpClientSettings.setProxyHost(httpHost);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nullable
    @Deprecated
    public final Credentials getProxyCredentials() {
        return this.m_aHttpClientSettings.getProxyCredentials();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aHttpClientSettings.setProxyCredentials(credentials);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> nonProxyHosts() {
        return this.m_aHttpClientSettings.nonProxyHosts();
    }

    @Deprecated
    public final boolean isUseProxySystemProperties() {
        return this.m_aHttpClientSettings.isUseSystemProperties();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setUseProxySystemProperties(boolean bl) {
        this.m_aHttpClientSettings.setUseSystemProperties(bl);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Deprecated
    public final boolean isUseDNSClientCache() {
        return this.m_aHttpClientSettings.isUseDNSClientCache();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setUseDNSClientCache(boolean bl) {
        this.m_aHttpClientSettings.setUseDNSClientCache(bl);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Deprecated
    public final int getConnectionTimeoutMS() {
        return this.m_aHttpClientSettings.getConnectionTimeoutMS();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setConnectionTimeoutMS(int n) {
        this.m_aHttpClientSettings.setConnectionTimeoutMS(n);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Deprecated
    public final int getRequestTimeoutMS() {
        return this.m_aHttpClientSettings.getSocketTimeoutMS();
    }

    @Nonnull
    @Deprecated
    public final IMPLTYPE setRequestTimeoutMS(int n) {
        this.m_aHttpClientSettings.setSocketTimeoutMS(n);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Deprecated
    public final boolean isCheckCertificate() {
        return this.isVerifySignature();
    }

    public final boolean isVerifySignature() {
        return this.m_bVerifySignature;
    }

    @Deprecated
    @Nonnull
    public final IMPLTYPE setCheckCertificate(boolean bl) {
        return this.setVerifySignature(bl);
    }

    @Nonnull
    public final IMPLTYPE setVerifySignature(boolean bl) {
        this.m_bVerifySignature = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    @Nonnull
    public final IMPLTYPE setTrustStore(@Nonnull KeyStore keyStore) {
        ValueEnforcer.notNull(keyStore, "TrustStore");
        this.m_aTrustStore = keyStore;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isFollowSMPRedirects() {
        return this.m_bFollowSMPRedirects;
    }

    @Nonnull
    public final IMPLTYPE setFollowSMPRedirects(boolean bl) {
        this.m_bFollowSMPRedirects = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isXMLSchemaValidation() {
        return this.m_bXMLSchemaValidation;
    }

    @Nonnull
    public final IMPLTYPE setXMLSchemaValidation(boolean bl) {
        this.m_bXMLSchemaValidation = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Deprecated
    @Nullable
    public final String getUserAgent() {
        return this.m_aHttpClientSettings.getUserAgent();
    }

    @Deprecated
    @Nonnull
    public final IMPLTYPE setUserAgent(@Nullable String string) {
        this.m_aHttpClientSettings.setUserAgent(string);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nonnull
    @OverrideOnDemand
    protected HttpContext createHttpContext() {
        return HttpClientContext.create();
    }

    @Nonnull
    public <T> T executeRequest(@Nonnull HttpUriRequest httpUriRequest, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        HttpContext httpContext = this.createHttpContext();
        try (HttpClientManager httpClientManager = HttpClientManager.create(this.m_aHttpClientSettings);){
            T t = httpClientManager.execute(httpUriRequest, httpContext, responseHandler);
            return t;
        }
    }

    @Nonnull
    public static SMPClientException getConvertedException(@Nonnull Exception exception) {
        if (exception instanceof SMPClientException) {
            return (SMPClientException)exception;
        }
        if (exception instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception;
            int n = httpResponseException.getStatusCode();
            switch (n) {
                case 400: {
                    return new SMPClientBadRequestException(httpResponseException);
                }
                case 403: {
                    return new SMPClientUnauthorizedException(httpResponseException);
                }
                case 404: {
                    return new SMPClientNotFoundException(httpResponseException);
                }
            }
            return new SMPClientException("Error thrown with HTTP status code " + n, httpResponseException);
        }
        if (exception instanceof UnknownHostException) {
            return new SMPClientNotFoundException((UnknownHostException)exception);
        }
        if (exception instanceof ConnectException) {
            return new SMPClientNotFoundException((ConnectException)exception);
        }
        if (exception instanceof ClientProtocolException && exception.getCause() instanceof SMPClientException) {
            return (SMPClientException)exception.getCause();
        }
        return new SMPClientException("Unknown error thrown by SMP server (" + exception.getMessage() + ")", exception);
    }

    @Nonnull
    public <T> T executeGenericRequest(@Nonnull HttpUriRequest httpUriRequest, @Nonnull ResponseHandler<T> responseHandler) throws SMPClientException {
        try {
            return this.executeRequest(httpUriRequest, responseHandler);
        }
        catch (Exception exception) {
            throw AbstractGenericSMPClient.getConvertedException(exception);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("SMPHost", this.m_sSMPHost).append("VerifySignature", this.m_bVerifySignature).append("FollowSMPRedirects", this.m_bFollowSMPRedirects).append("XMLSchemaValidation", this.m_bXMLSchemaValidation).append("HttpClientSettings", this.m_aHttpClientSettings).getToString();
    }

    static {
        if (DEFAULT_TRUST_STORE != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully loaded configured SMP client trust store");
            }
        } else if (StringHelper.hasNoText(SMPClientConfiguration.getTrustStorePath())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No SMP client trust store is configured");
            }
        } else {
            LOGGER.warn("Failed to load the configured SMP client trust store");
        }
    }
}

