/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.commons.ValueEnforcer;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr2.BDXR2ClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IBDXR2ServiceMetadataProvider {
    @Nullable
    public ServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier var1, @Nonnull IDocumentTypeIdentifier var2) throws SMPClientException;

    @Nullable
    default public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcessID");
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        ServiceMetadataType serviceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return serviceMetadataType == null ? null : BDXR2ClientReadOnly.getEndpoint(serviceMetadataType, iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    default public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXR2ClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public byte[] getEndpointCertificateBytes(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXR2ClientReadOnly.getEndpointCertificateBytes(endpointType);
    }

    @Nullable
    default public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        byte[] byArray = this.getEndpointCertificateBytes(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertByteArrayToCertficateDirect(byArray);
    }
}

