/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr2.IBDXR2ServiceGroupProvider;
import com.helger.smpclient.bdxr2.IBDXR2ServiceMetadataProvider;
import com.helger.smpclient.bdxr2.marshal.BDXR2ServiceGroupMarshaller;
import com.helger.smpclient.bdxr2.marshal.BDXR2ServiceMetadataMarshaller;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp2.ServiceGroupType;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.CertificateType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import com.helger.xsds.bdxr.smp2.ac.ProcessMetadataType;
import com.helger.xsds.bdxr.smp2.ac.ProcessType;
import com.helger.xsds.bdxr.smp2.ac.RedirectType;
import com.helger.xsds.bdxr.smp2.ac.ServiceReferenceType;
import com.helger.xsds.bdxr.smp2.bc.IDType;
import com.helger.xsds.xmldsig.X509DataType;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXR2ClientReadOnly
extends AbstractGenericSMPClient<BDXR2ClientReadOnly>
implements IBDXR2ServiceGroupProvider,
IBDXR2ServiceMetadataProvider {
    public static final String PATH_OASIS_BDXR_SMP_2 = "bdxr-smp-2/";
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXR2ClientReadOnly.class);

    public BDXR2ClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public BDXR2ClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public BDXR2ClientReadOnly(@Nonnull URI uRI) {
        super(uRI);
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        String string = this.getSMPHostURI() + PATH_OASIS_BDXR_SMP_2 + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        return this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(new BDXR2ServiceGroupMarshaller(this.isXMLSchemaValidation())));
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull(iIdentifierFactory, "IdentifierFactory");
        CommonsArrayList<IDocumentTypeIdentifier> commonsArrayList = new CommonsArrayList<IDocumentTypeIdentifier>();
        if (serviceGroupType != null) {
            for (ServiceReferenceType serviceReferenceType : serviceGroupType.getServiceReference()) {
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                IDType iDType = serviceReferenceType.getID();
                if (iDType == null || (iDocumentTypeIdentifier = iIdentifierFactory.createDocumentTypeIdentifier(iDType.getSchemeID(), iDType.getValue())) == null) continue;
                commonsArrayList.add(iDocumentTypeIdentifier);
            }
        }
        return commonsArrayList;
    }

    @Deprecated
    @Nonnull
    public ServiceMetadataType getServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Nonnull
    public ServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        String string = this.getSMPHostURI() + PATH_OASIS_BDXR_SMP_2 + iParticipantIdentifier.getURIPercentEncoded() + "/" + URL_PART_SERVICES + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        HttpGet httpGet = new HttpGet(string);
        KeyStore keyStore = this.getTrustStore();
        ServiceMetadataType serviceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<ServiceMetadataType>(new BDXR2ServiceMetadataMarshaller(bl), keyStore).setVerifySignature(bl2));
        if (!SimpleDocumentTypeIdentifier.wrap(serviceMetadataType.getID()).equals(iDocumentTypeIdentifier)) {
            throw new SMPClientException("Requested document type '" + iDocumentTypeIdentifier.getURIEncoded() + "' and received '" + CIdentifier.getURIEncoded(serviceMetadataType.getID()) + "' - mismatch. Ignoring request.");
        }
        if (this.isFollowSMPRedirects()) {
            for (ProcessMetadataType processMetadataType : serviceMetadataType.getProcessMetadata()) {
                RedirectType redirectType = processMetadataType.getRedirect();
                if (redirectType == null) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Following a redirect from '" + string + "' to '" + redirectType.getPublisherURIValue() + "'");
                }
                httpGet = new HttpGet(redirectType.getPublisherURIValue());
                serviceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<ServiceMetadataType>(new BDXR2ServiceMetadataMarshaller(bl), keyStore).setVerifySignature(bl2));
                boolean bl3 = false;
                if (serviceMetadataType.hasSignatureEntries()) {
                    block3: for (Object object : serviceMetadataType.getSignatureAtIndex(0).getKeyInfo().getContent()) {
                        Object t = ((JAXBElement)object).getValue();
                        if (!(t instanceof X509DataType)) continue;
                        X509DataType x509DataType = (X509DataType)t;
                        for (Object object2 : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                            JAXBElement jAXBElement = (JAXBElement)object2;
                            if (!(jAXBElement.getValue() instanceof X509Certificate)) continue;
                            X509Certificate x509Certificate = (X509Certificate)jAXBElement.getValue();
                            boolean bl4 = false;
                            CommonsArrayList commonsArrayList = new CommonsArrayList();
                            for (CertificateType certificateType : redirectType.getCertificate()) {
                                try {
                                    X509Certificate x509Certificate2 = CertificateHelper.convertByteArrayToCertficate(certificateType.getContentBinaryObjectValue());
                                    if (x509Certificate2 == null) continue;
                                    commonsArrayList.add(x509Certificate2);
                                    if (!x509Certificate2.equals(x509Certificate)) continue;
                                    bl4 = true;
                                    break;
                                }
                                catch (CertificateException certificateException) {
                                    LOGGER.error("SMP Redirect contains an invalid certificate", certificateException);
                                }
                            }
                            if (!bl4) {
                                throw new SMPClientException("No certificate of the redirect matched the provided certificate. Retrieved certificate is '" + x509Certificate + "'. Allowed certificates according to the redirect are: " + commonsArrayList);
                            }
                            bl3 = true;
                            break block3;
                        }
                    }
                }
                if (bl3) continue;
                throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
            }
        }
        return serviceMetadataType;
    }

    @Deprecated
    @Nullable
    public ServiceMetadataType getServiceRegistrationOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Override
    @Nullable
    public ServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull(serviceMetadataType, "SignedServiceMetadata");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcessID");
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        for (ProcessMetadataType processMetadataType : serviceMetadataType.getProcessMetadata()) {
            boolean bl = false;
            for (ProcessType object : processMetadataType.getProcess()) {
                if (!SimpleProcessIdentifier.wrap(object.getID()).equals(iProcessIdentifier)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (EndpointType endpointType : processMetadataType.getEndpoint()) {
                if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfileIDValue())) continue;
                commonsArrayList.add(endpointType);
            }
            if (commonsArrayList.size() != 1 && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process '" + iProcessIdentifier.getURIEncoded() + "' and transport profile '" + iSMPTransportProfile.getID() + "'" + (commonsArrayList.isEmpty() ? "" : ": " + ((Object)commonsArrayList).toString() + " - using the first one"));
            }
            return (EndpointType)commonsArrayList.getFirst();
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getAddressURIValue();
    }

    @Nullable
    public static byte[] getEndpointCertificateBytes(@Nullable EndpointType endpointType) {
        if (endpointType == null) {
            return null;
        }
        if (endpointType.getCertificateCount() == 0) {
            return null;
        }
        return endpointType.getCertificateAtIndex(0).getContentBinaryObjectValue();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        byte[] byArray = BDXR2ClientReadOnly.getEndpointCertificateBytes(endpointType);
        return CertificateHelper.convertByteArrayToCertficateDirect(byArray);
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new BDXR2ClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static ServiceMetadataType getServiceRegistrationByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new BDXR2ClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

