/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.bdxr.smp2.participant.BDXR2ParticipantIdentifier;
import com.helger.smpclient.bdxr2.BDXR2ClientReadOnly;
import com.helger.smpclient.bdxr2.marshal.BDXR2ServiceGroupMarshaller;
import com.helger.smpclient.bdxr2.marshal.BDXR2ServiceMetadataMarshaller;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp2.ServiceGroupType;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import com.helger.xsds.bdxr.smp2.ac.ProcessMetadataType;
import com.helger.xsds.bdxr.smp2.ac.RedirectType;
import com.helger.xsds.bdxr.smp2.bc.IDType;
import com.helger.xsds.bdxr.smp2.bc.ParticipantIDType;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXR2Client
extends BDXR2ClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXR2Client.class);

    public BDXR2Client(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public BDXR2Client(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, string);
    }

    public BDXR2Client(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(serviceGroupType, "ServiceGroup");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = new BDXR2ServiceGroupMarshaller().getAsString(serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + serviceGroupType);
        }
        String string2 = this.getSMPHostURI() + "bdxr-smp-2/" + CIdentifier.getURIPercentEncoded(serviceGroupType.getParticipantID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantID(new BDXR2ParticipantIdentifier(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()));
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + "bdxr-smp-2/" + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new BDXR2ServiceMetadataMarshaller().getAsString(serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + serviceMetadataType);
        }
        String string2 = this.getSMPHostURI() + "bdxr-smp-2/" + CIdentifier.getURIPercentEncoded(serviceMetadataType.getParticipantID()) + "/services/" + CIdentifier.getURIPercentEncoded(serviceMetadataType.getID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceEndpoints(@Nonnull ParticipantIDType participantIDType, @Nonnull IDType iDType, @Nonnull List<EndpointType> list, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(participantIDType, "ServiceGroupID");
        ValueEnforcer.notNull(iDType, "DocumentTypeID");
        ValueEnforcer.notNull(list, "Endpoints");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setSMPVersionID("2.0");
        serviceMetadataType.setID(iDType);
        serviceMetadataType.setParticipantID(participantIDType);
        ProcessMetadataType processMetadataType = new ProcessMetadataType();
        processMetadataType.getEndpoint().addAll(list);
        serviceMetadataType.addProcessMetadata(processMetadataType);
        this._saveServiceInformation(serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull ParticipantIDType participantIDType, @Nonnull IDType iDType, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(participantIDType, "ServiceGroupID");
        ValueEnforcer.notNull(iDType, "DocumentTypeID");
        ValueEnforcer.notNull(redirectType, "Redirect");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setSMPVersionID("2.0");
        serviceMetadataType.setID(iDType);
        serviceMetadataType.setParticipantID(participantIDType);
        ProcessMetadataType processMetadataType = new ProcessMetadataType();
        processMetadataType.setRedirect(redirectType);
        serviceMetadataType.addProcessMetadata(processMetadataType);
        this._saveServiceInformation(serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + "bdxr-smp-2/" + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

