/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.bdxr.smp1.participant.BDXR1ParticipantIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceGroupType;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceMetadataType;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.DocumentIdentifierType;
import com.helger.xsds.bdxr.smp1.ParticipantIdentifierType;
import com.helger.xsds.bdxr.smp1.RedirectType;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClient
extends BDXRClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXRClient.class);

    public BDXRClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public BDXRClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, string);
    }

    public BDXRClient(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(serviceGroupType, "ServiceGroup");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = new BDXR1MarshallerServiceGroupType(this.isXMLSchemaValidation()).getAsString(serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + serviceGroupType);
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded(serviceGroupType.getParticipantIdentifier());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier(new BDXR1ParticipantIdentifier(iParticipantIdentifier));
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull ParticipantIdentifierType participantIdentifierType, @Nonnull DocumentIdentifierType documentIdentifierType, @Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new BDXR1MarshallerServiceMetadataType(this.isXMLSchemaValidation()).getAsString(serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + serviceMetadataType);
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded(participantIdentifierType) + "/" + "services" + "/" + CIdentifier.getURIPercentEncoded(documentIdentifierType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceInformation(@Nonnull ServiceInformationType serviceInformationType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(serviceInformationType, "ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull(serviceInformationType.getParticipantIdentifier(), "ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull(serviceInformationType.getDocumentIdentifier(), "ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        this._saveServiceInformation(serviceInformationType.getParticipantIdentifier(), serviceInformationType.getDocumentIdentifier(), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull ParticipantIdentifierType participantIdentifierType, @Nonnull DocumentIdentifierType documentIdentifierType, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(participantIdentifierType, "ServiceGroupID");
        ValueEnforcer.notNull(documentIdentifierType, "DocumentTypeID");
        ValueEnforcer.notNull(redirectType, "Redirect");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setRedirect(redirectType);
        this._saveServiceInformation(participantIdentifierType, documentIdentifierType, serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/" + "services" + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

