/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CompressFilterSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressFilterSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static boolean s_bFilterLoaded = false;
    private static boolean s_bResponseCompressionEnabled = true;
    private static boolean s_bResponseGzipEnabled = true;
    private static boolean s_bResponseDeflateEnabled = true;
    private static boolean s_bDebugModeEnabled = false;
    private static final CompressFilterSettings s_aInstance = new CompressFilterSettings();

    private CompressFilterSettings() {
    }

    public static boolean isFilterLoaded() {
        return s_aRWLock.readLockedBoolean(() -> s_bFilterLoaded);
    }

    public static void markFilterLoaded() {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bFilterLoaded = true;
            return true;
        });
        LOGGER.info("CompressFilter is loaded");
    }

    public static boolean isResponseCompressionEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseCompressionEnabled);
    }

    @Nonnull
    public static EChange setResponseCompressionEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseCompressionEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseCompressionEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseCompressionEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseGzipEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseGzipEnabled);
    }

    @Nonnull
    public static EChange setResponseGzipEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseGzipEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseGzipEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseGzipEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseDeflateEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseDeflateEnabled);
    }

    @Nonnull
    public static EChange setResponseDeflateEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseDeflateEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseDeflateEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseDeflateEnabled=" + bl);
        }
        return eChange;
    }

    @Nonnull
    public static EChange setAll(boolean bl, boolean bl2, boolean bl3) {
        return CompressFilterSettings.setResponseCompressionEnabled(bl).or(CompressFilterSettings.setResponseGzipEnabled(bl2)).or(CompressFilterSettings.setResponseDeflateEnabled(bl3));
    }

    public static boolean isDebugModeEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugModeEnabled);
    }

    @Nonnull
    public static EChange setDebugModeEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bDebugModeEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bDebugModeEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter debugMode=" + bl);
        }
        return eChange;
    }
}

