/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.http.CacheControlBuilder;
import com.helger.http.EHttpReferrerPolicy;
import com.helger.servlet.response.EXFrameOptionType;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.Cookie;

@ThreadSafe
public final class UnifiedResponseDefaultSettings {
    public static final boolean DEFAULT_HTTP_HEADER_VALUES_UNIFIED = true;
    public static final boolean DEFAULT_HTTP_HEADER_VALUES_QUOTE_IF_NECESSARY = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final HttpHeaderMap s_aResponseHeaderMap = new HttpHeaderMap();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsOrderedMap<String, Cookie> s_aCookies = new CommonsLinkedHashMap<String, Cookie>();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bHttpHeaderValuesUnified = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bHttpHeaderValuesQuoteIfNecessary = false;

    private UnifiedResponseDefaultSettings() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getResponseHeaderMap() {
        return s_aRWLock.readLockedGet(s_aResponseHeaderMap::getClone);
    }

    public static void setAllowMimeSniffing(boolean bl) {
        if (bl) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("X-Content-Type-Options");
        } else {
            UnifiedResponseDefaultSettings.setResponseHeader("X-Content-Type-Options", "nosniff");
        }
    }

    public static void setEnableXSSFilter(boolean bl) {
        if (bl) {
            UnifiedResponseDefaultSettings.setResponseHeader("X-XSS-Protection", "1; mode=block");
        } else {
            UnifiedResponseDefaultSettings.removeResponseHeaders("X-XSS-Protection");
        }
    }

    public static void setStrictTransportSecurity(@Nonnegative int n, boolean bl) {
        UnifiedResponseDefaultSettings.setResponseHeader("Strict-Transport-Security", new CacheControlBuilder().setMaxAgeSeconds(n).getAsHTTPHeaderValue() + (bl ? ";includeSubDomains" : ""));
    }

    public static void removeStrictTransportSecurity() {
        UnifiedResponseDefaultSettings.removeResponseHeaders("Strict-Transport-Security");
    }

    public static void setXFrameOptions(@Nullable EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        if (eXFrameOptionType != null && eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull(iSimpleURL, "Domain");
        }
        if (eXFrameOptionType == null) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("X-Frame-Options");
        } else {
            String string = eXFrameOptionType.isURLRequired() ? eXFrameOptionType.getID() + " " + iSimpleURL.getAsStringWithEncodedParameters() : eXFrameOptionType.getID();
            UnifiedResponseDefaultSettings.setResponseHeader("X-Frame-Options", string);
        }
    }

    public static void setReferrerPolicy(@Nullable EHttpReferrerPolicy eHttpReferrerPolicy) {
        if (eHttpReferrerPolicy == null || eHttpReferrerPolicy == EHttpReferrerPolicy.NONE) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("Referrer-Policy");
        } else {
            UnifiedResponseDefaultSettings.setResponseHeader("Referrer-Policy", eHttpReferrerPolicy.getValue());
        }
    }

    public static void setResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notEmpty(string2, "Value");
        s_aRWLock.writeLocked(() -> s_aResponseHeaderMap.setHeader(string, string2));
    }

    public static void addResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notEmpty(string2, "Value");
        s_aRWLock.writeLocked(() -> s_aResponseHeaderMap.addHeader(string, string2));
    }

    @Nonnull
    public static EChange removeResponseHeaders(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        return s_aRWLock.writeLockedGet(() -> s_aResponseHeaderMap.removeHeaders(string));
    }

    @Nonnull
    public static EChange removeAllResponseHeaders() {
        return s_aRWLock.writeLockedGet(s_aResponseHeaderMap::removeAll);
    }

    public static boolean hasCookies() {
        return s_aRWLock.readLockedBoolean(s_aCookies::isNotEmpty);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, Cookie> getAllCookies() {
        return s_aRWLock.readLockedGet(s_aCookies::getClone);
    }

    public static void addCookie(@Nonnull Cookie cookie) {
        ValueEnforcer.notNull(cookie, "Cookie");
        String string = cookie.getName();
        s_aRWLock.writeLockedGet(() -> s_aCookies.put(string, cookie));
    }

    @Nonnull
    public static EChange removeCookie(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        return s_aRWLock.writeLockedGet(() -> s_aCookies.removeObject(string));
    }

    @Nonnull
    public static EChange removeAllCookies() {
        return s_aRWLock.writeLockedGet(s_aCookies::removeAll);
    }

    public static boolean isHttpHeaderValuesUnified() {
        return s_aRWLock.readLockedBoolean(() -> s_bHttpHeaderValuesUnified);
    }

    public static void setHttpHeaderValuesUnified(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bHttpHeaderValuesUnified = bl;
            return s_bHttpHeaderValuesUnified;
        });
    }

    public static boolean isHttpHeaderValuesQuoteIfNecessary() {
        return s_aRWLock.readLockedBoolean(() -> s_bHttpHeaderValuesQuoteIfNecessary);
    }

    public static void setHttpHeaderValuesQuoteIfNecessary(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bHttpHeaderValuesQuoteIfNecessary = bl;
            return s_bHttpHeaderValuesQuoteIfNecessary;
        });
    }

    static {
        UnifiedResponseDefaultSettings.setAllowMimeSniffing(false);
        UnifiedResponseDefaultSettings.setEnableXSSFilter(true);
        UnifiedResponseDefaultSettings.setStrictTransportSecurity(3600, true);
        UnifiedResponseDefaultSettings.setXFrameOptions(EXFrameOptionType.DEFAULT, null);
        UnifiedResponseDefaultSettings.setReferrerPolicy(EHttpReferrerPolicy.NONE);
    }
}

