/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.state.EChange;
import java.time.LocalDateTime;
import java.time.Month;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ResponseHelperSettings {
    public static final LocalDateTime EXPIRES_NEVER_DATETIME = LocalDateTime.of(1995, Month.MAY, 6, 12, 0, 0);
    public static final String EXPIRES_NEVER_STRING = PDTWebDateHelper.getAsStringRFC822(EXPIRES_NEVER_DATETIME);
    public static final int DEFAULT_EXPIRATION_SECONDS = 604800;
    public static final boolean DEFAULT_RESPONSE_COMPRESSION_ENABLED = true;
    public static final boolean DEFAULT_RESPONSE_GZIP_ENABLED = true;
    public static final boolean DEFAULT_RESPONSE_DERFLATE_ENABLED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHelperSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static int s_nExpirationSeconds = 604800;
    private static boolean s_bResponseCompressionEnabled = true;
    private static boolean s_bResponseGzipEnabled = true;
    private static boolean s_bResponseDeflateEnabled = true;
    private static final ResponseHelperSettings s_aInstance = new ResponseHelperSettings();

    private ResponseHelperSettings() {
    }

    public static boolean isResponseCompressionEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseCompressionEnabled);
    }

    @Nonnull
    public static EChange setResponseCompressionEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseCompressionEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseCompressionEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("ResponseHelper responseCompressionEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseGzipEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseGzipEnabled);
    }

    @Nonnull
    public static EChange setResponseGzipEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseGzipEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseGzipEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("ResponseHelper responseGzipEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseDeflateEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bResponseDeflateEnabled);
    }

    @Nonnull
    public static EChange setResponseDeflateEnabled(boolean bl) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_bResponseDeflateEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseDeflateEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("ResponseHelper responseDeflateEnabled=" + bl);
        }
        return eChange;
    }

    @Nonnull
    public static EChange setAll(boolean bl, boolean bl2, boolean bl3) {
        return ResponseHelperSettings.setResponseCompressionEnabled(bl).or(ResponseHelperSettings.setResponseGzipEnabled(bl2)).or(ResponseHelperSettings.setResponseDeflateEnabled(bl3));
    }

    public static int getExpirationSeconds() {
        return s_aRWLock.readLockedInt(() -> s_nExpirationSeconds);
    }

    @Nonnull
    public static EChange setExpirationSeconds(int n) {
        EChange eChange = s_aRWLock.writeLockedGet(() -> {
            if (s_nExpirationSeconds == n) {
                return EChange.UNCHANGED;
            }
            s_nExpirationSeconds = n;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("ResponseHelper expirationSeconds=" + n);
        }
        return eChange;
    }
}

