/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.StringHelper;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.request.RequestParamMapItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IRequestParamMap
extends IHasSize,
Serializable {
    public boolean contains(String ... var1);

    @Nullable
    public RequestParamMapItem getObject(String ... var1);

    @Nullable
    default public String getString(String ... stringArray) {
        RequestParamMapItem requestParamMapItem = this.getObject(stringArray);
        return requestParamMapItem == null ? null : requestParamMapItem.getValue();
    }

    @Nullable
    default public String getStringTrimmed(String ... stringArray) {
        RequestParamMapItem requestParamMapItem = this.getObject(stringArray);
        return requestParamMapItem == null ? null : requestParamMapItem.getValueTrimmed();
    }

    default public boolean getBoolean(@Nonnull @Nonempty String string, boolean bl) {
        RequestParamMapItem requestParamMapItem = this.getObject(string);
        return requestParamMapItem == null ? bl : TypeConverter.convertToBoolean(requestParamMapItem.getValue(), bl);
    }

    default public double getDouble(@Nonnull @Nonempty String string, double d) {
        RequestParamMapItem requestParamMapItem = this.getObject(string);
        return requestParamMapItem == null ? d : TypeConverter.convertToDouble(requestParamMapItem.getValue(), d);
    }

    default public int getInt(@Nonnull @Nonempty String string, int n) {
        RequestParamMapItem requestParamMapItem = this.getObject(string);
        return requestParamMapItem == null ? n : TypeConverter.convertToInt(requestParamMapItem.getValue(), n);
    }

    default public long getLong(@Nonnull @Nonempty String string, long l) {
        RequestParamMapItem requestParamMapItem = this.getObject(string);
        return requestParamMapItem == null ? l : TypeConverter.convertToLong(requestParamMapItem.getValue(), l);
    }

    @Nullable
    default public BigInteger getBigInteger(String ... stringArray) {
        RequestParamMapItem requestParamMapItem = this.getObject(stringArray);
        return requestParamMapItem == null ? null : TypeConverter.convert(requestParamMapItem.getValue(), BigInteger.class);
    }

    @Nullable
    default public BigDecimal getBigDecimal(String ... stringArray) {
        RequestParamMapItem requestParamMapItem = this.getObject(stringArray);
        return requestParamMapItem == null ? null : TypeConverter.convert(requestParamMapItem.getValue(), BigDecimal.class);
    }

    default public boolean isCheckBoxChecked(@Nullable String string, boolean bl) {
        if (StringHelper.hasText(string)) {
            String string2 = this.getString(string);
            if (string2 != null) {
                return true;
            }
            if (this.containsKey(RequestHelper.getCheckBoxHiddenFieldName(string))) {
                return false;
            }
        }
        return bl;
    }

    @Nullable
    public ICommonsOrderedMap<String, String> getValueMap(String ... var1);

    @Nullable
    public ICommonsOrderedMap<String, String> getValueTrimmedMap(String ... var1);

    @Nullable
    public IRequestParamMap getMap(String ... var1);

    public boolean containsKey(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> keySet();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<RequestParamMapItem> values();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, RequestParamMapItem> getAsObjectMap();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAsValueMap();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAsValueTrimmedMap();
}

