/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.mock.MockServletConfig;
import com.helger.servlet.mock.MockServletContext;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockServletPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockServletPool.class);
    private final MockServletContext m_aSC;
    private final ICommonsList<ServletItem> m_aServlets = new CommonsArrayList<ServletItem>();
    private boolean m_bInvalidated = false;

    public MockServletPool(@Nonnull MockServletContext mockServletContext) {
        this.m_aSC = ValueEnforcer.notNull(mockServletContext, "ServletContext");
    }

    public void registerServlet(@Nonnull Class<? extends Servlet> clazz, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.registerServlet(clazz, string, string2, null);
    }

    public void registerServlet(@Nonnull Class<? extends Servlet> clazz, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable Map<String, String> map) {
        ValueEnforcer.notNull(clazz, "ServletClass");
        ValueEnforcer.notEmpty(string, "ServletPath");
        for (ServletItem object2 : this.m_aServlets) {
            if (object2.getServletPath().equals(string)) {
                throw new IllegalArgumentException("Another servlet with the path '" + string + "' is already registered: " + object2);
            }
            if (!object2.getServletName().equals(string2)) continue;
            throw new IllegalArgumentException("Another servlet with the name '" + string2 + "' is already registered: " + object2);
        }
        Servlet servlet = GenericReflection.newInstance(clazz);
        if (servlet == null) {
            throw new IllegalArgumentException("Failed to instantiate servlet class " + clazz);
        }
        MockServletConfig mockServletConfig = this.m_aSC.createServletConfig(string2, map);
        try {
            servlet.init(mockServletConfig);
        }
        catch (ServletException servletException) {
            throw new IllegalStateException("Failed to init servlet " + servlet + " with configuration  " + mockServletConfig + " for path '" + string + "'");
        }
        this.m_aServlets.add(new ServletItem(servlet, string));
    }

    @Nullable
    public Servlet getServletOfPath(@Nullable String string) {
        int n;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.hasText(string)) {
            this.m_aServlets.findAll(servletItem -> servletItem.matchesPath(string), commonsArrayList::add);
        }
        if ((n = commonsArrayList.size()) == 0) {
            return null;
        }
        if (n > 1 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Found more than 1 servlet matching path '" + string + "' - using first one: " + commonsArrayList);
        }
        return ((ServletItem)commonsArrayList.getFirst()).getServlet();
    }

    public void invalidate() {
        if (this.m_bInvalidated) {
            throw new IllegalArgumentException("Servlet pool already invalidated!");
        }
        this.m_bInvalidated = true;
        for (ServletItem servletItem : this.m_aServlets) {
            try {
                servletItem.getServlet().destroy();
            }
            catch (Exception exception) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Failed to destroy servlet " + servletItem, exception);
            }
        }
        this.m_aServlets.clear();
    }

    private static final class ServletItem {
        private final Servlet m_aServlet;
        private final String m_sServletPath;
        private final String m_sServletPathRegEx;

        @Nonnull
        @Nonempty
        private static String _getAsRegEx(@Nonnull @Nonempty String string) {
            String string2 = string;
            if (string2.endsWith("/*")) {
                string2 = string.substring(0, string.length() - 2);
            }
            return StringHelper.replaceAll(string2, "*", ".*");
        }

        public ServletItem(@Nonnull Servlet servlet, @Nonnull @Nonempty String string) {
            this.m_aServlet = ValueEnforcer.notNull(servlet, "Servlet");
            this.m_sServletPath = ValueEnforcer.notEmpty(string, "ServletPath");
            this.m_sServletPathRegEx = ServletItem._getAsRegEx(string);
        }

        @Nonnull
        public Servlet getServlet() {
            return this.m_aServlet;
        }

        @Nonnull
        @Nonempty
        public String getServletName() {
            return this.m_aServlet.getServletConfig().getServletName();
        }

        @Nonnull
        @Nonempty
        public String getServletPath() {
            return this.m_sServletPath;
        }

        public boolean matchesPath(@Nonnull String string) {
            return RegExHelper.stringMatchesPattern(this.m_sServletPathRegEx, string);
        }

        public String toString() {
            return new ToStringGenerator(this).append("servlet", this.m_aServlet).append("servletPath", this.m_sServletPath).getToString();
        }
    }
}

