/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.servlet.mock.MockEventListenerList;
import java.util.EventListener;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;

@ThreadSafe
public final class MockHttpListener {
    private static MockEventListenerList s_aDefaultListener = new MockEventListenerList();
    private static MockEventListenerList s_aCurrentListener = new MockEventListenerList();

    private MockHttpListener() {
    }

    public static void addDefaultListener(@Nonnull EventListener eventListener) {
        s_aDefaultListener.addListener(eventListener);
    }

    public static void removeDefaultListeners(@Nonnull Class<? extends EventListener> clazz) {
        s_aDefaultListener.removeListeners(clazz);
    }

    public static void removeAllDefaultListeners() {
        s_aDefaultListener.removeAllListeners();
    }

    public static void setCurrentToDefault() {
        s_aCurrentListener.setFrom(s_aDefaultListener);
    }

    public static void addListener(@Nonnull EventListener eventListener) {
        s_aCurrentListener.addListener(eventListener);
    }

    public static void removeListeners(@Nonnull Class<? extends EventListener> clazz) {
        s_aCurrentListener.removeListeners(clazz);
    }

    public static void removeAllListeners() {
        s_aCurrentListener.removeAllListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ServletContextListener> getAllServletContextListeners() {
        return s_aCurrentListener.getAllServletContextListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<HttpSessionListener> getAllHttpSessionListeners() {
        return s_aCurrentListener.getAllHttpSessionListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ServletRequestListener> getAllServletRequestListeners() {
        return s_aCurrentListener.getAllServletRequestListeners();
    }
}

