/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.logging;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.filter.AbstractHttpServletFilter;
import com.helger.servlet.logging.LoggingHttpServletRequestWrapper;
import com.helger.servlet.logging.LoggingHttpServletResponseWrapper;
import com.helger.servlet.logging.LoggingRequest;
import com.helger.servlet.logging.LoggingResponse;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.ResponseHelper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
extends AbstractHttpServletFilter {
    private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
    private Logger m_aLogger = LoggerFactory.getLogger(this.getClass());
    private int m_nMaxContentSize = 1024;
    private final ICommonsSet<String> m_aExcludedPaths = new CommonsHashSet<String>();
    private String m_sRequestPrefix = "REQUEST: ";
    private String m_sResponsePrefix = "RESPONSE: ";

    public static void setGloballyEnabled(boolean bl) {
        ENABLED.set(bl);
    }

    public static boolean isGloballyEnabled() {
        return ENABLED.get();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        String string;
        String string2;
        String string3;
        String string4;
        FilterConfig filterConfig = this.getFilterConfig();
        String string5 = filterConfig.getInitParameter("loggerName");
        if (StringHelper.hasText(string5)) {
            this.m_aLogger = LoggerFactory.getLogger(string5);
        }
        if ((string4 = filterConfig.getInitParameter("maxContentSize")) != null) {
            this.m_nMaxContentSize = Integer.parseInt(string4);
        }
        if (StringHelper.hasText(string3 = filterConfig.getInitParameter("excludedPaths"))) {
            this.m_aExcludedPaths.setAll((String[])RegExHelper.getSplitToArray(string3, "\\s*,\\s*"));
        }
        if (StringHelper.hasText(string2 = filterConfig.getInitParameter("requestPrefix"))) {
            this.m_sRequestPrefix = string2;
        }
        if (StringHelper.hasText(string = filterConfig.getInitParameter("responsePrefix"))) {
            this.m_sResponsePrefix = string;
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected String getRequestDescription(@Nonnull LoggingHttpServletRequestWrapper loggingHttpServletRequestWrapper) {
        LoggingRequest loggingRequest = new LoggingRequest();
        loggingRequest.setSender(loggingHttpServletRequestWrapper.getLocalAddr());
        loggingRequest.setMethod(loggingHttpServletRequestWrapper.getMethod());
        loggingRequest.setPath(ServletHelper.getRequestRequestURI(loggingHttpServletRequestWrapper));
        loggingRequest.setParams(loggingHttpServletRequestWrapper.isFormPost() ? null : loggingHttpServletRequestWrapper.getParameters());
        loggingRequest.setHeaders(RequestHelper.getRequestHeaderMap(loggingHttpServletRequestWrapper));
        String string = loggingHttpServletRequestWrapper.getContent();
        if (this.m_aLogger.isTraceEnabled() || this.m_nMaxContentSize <= 0) {
            loggingRequest.setBody(string);
        } else {
            loggingRequest.setBody(string.substring(0, Math.min(string.length(), this.m_nMaxContentSize)));
        }
        return loggingRequest.getAsJson().getAsJsonString();
    }

    @Nonnull
    @OverrideOnDemand
    protected String getResponseDescription(@Nonnull LoggingHttpServletResponseWrapper loggingHttpServletResponseWrapper) {
        LoggingResponse loggingResponse = new LoggingResponse();
        loggingResponse.setStatus(loggingHttpServletResponseWrapper.getStatus());
        loggingResponse.setHeaders(ResponseHelper.getResponseHeaderMap(loggingHttpServletResponseWrapper));
        String string = loggingHttpServletResponseWrapper.getContentAsString();
        if (this.m_aLogger.isTraceEnabled() || this.m_nMaxContentSize <= 0) {
            loggingResponse.setBody(string);
        } else {
            loggingResponse.setBody(string.substring(0, Math.min(string.length(), this.m_nMaxContentSize)));
        }
        return loggingResponse.getAsJson().getAsJsonString();
    }

    @OverrideOnDemand
    protected boolean isLogRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        boolean bl;
        boolean bl2 = bl = LoggingFilter.isGloballyEnabled() && this.m_aLogger.isInfoEnabled();
        if (bl) {
            String string = ServletHelper.getRequestRequestURI(httpServletRequest);
            for (String string2 : this.m_aExcludedPaths) {
                if (!string.startsWith(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void doHttpFilter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull FilterChain filterChain) throws IOException, ServletException {
        if (this.isLogRequest(httpServletRequest, httpServletResponse)) {
            LoggingHttpServletRequestWrapper loggingHttpServletRequestWrapper = new LoggingHttpServletRequestWrapper(httpServletRequest);
            LoggingHttpServletResponseWrapper loggingHttpServletResponseWrapper = new LoggingHttpServletResponseWrapper(httpServletResponse);
            if (this.m_aLogger.isInfoEnabled()) {
                this.m_aLogger.info(this.m_sRequestPrefix + this.getRequestDescription(loggingHttpServletRequestWrapper));
            }
            filterChain.doFilter(loggingHttpServletRequestWrapper, loggingHttpServletResponseWrapper);
            if (this.m_aLogger.isInfoEnabled()) {
                this.m_aLogger.info(this.m_sResponsePrefix + this.getResponseDescription(loggingHttpServletResponseWrapper));
            }
            loggingHttpServletResponseWrapper.writeContentTo(httpServletResponse.getOutputStream());
        } else {
            filterChain.doFilter(httpServletRequest, httpServletResponse);
        }
    }
}

