/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.password.hash.IPasswordHashCreator;
import javax.annotation.Nonnull;

public abstract class AbstractPasswordHashCreator
implements IPasswordHashCreator {
    private final String m_sAlgorithm;

    public AbstractPasswordHashCreator(@Nonnull @Nonempty String string) {
        this.m_sAlgorithm = ValueEnforcer.notEmpty(string, "Algorithm");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAlgorithmName() {
        return this.m_sAlgorithm;
    }

    public String toString() {
        return new ToStringGenerator(this).append("algorithm", this.m_sAlgorithm).getToString();
    }
}

