/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.crypto.Mac;

public class MacInputStream
extends WrappedInputStream {
    public static final boolean DEFAULT_ON = true;
    private Mac m_aMac;
    private boolean m_bOn = true;

    public MacInputStream(@Nonnull InputStream inputStream, @Nonnull Mac mac) {
        super(inputStream);
        this.setMac(mac);
    }

    @Nonnull
    public final Mac getMac() {
        return this.m_aMac;
    }

    public final void setMac(@Nonnull Mac mac) {
        ValueEnforcer.notNull(mac, "Mac");
        this.m_aMac = mac;
    }

    public final void setOn(boolean bl) {
        this.m_bOn = bl;
    }

    public final boolean isOn() {
        return this.m_bOn;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (this.m_bOn && n != -1) {
            this.m_aMac.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.m_bOn && n3 != -1) {
            this.m_aMac.update(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Mac", this.m_aMac).append("On", this.m_bOn).getToString();
    }
}

