/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.security.authentication.result.AuthToken;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.result.IAuthToken;
import com.helger.security.authentication.subject.IAuthSubject;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AuthTokenRegistry {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final ICommonsMap<String, AuthToken> s_aMap = new CommonsHashMap<String, AuthToken>();

    private AuthTokenRegistry() {
    }

    @Nonnull
    public static IAuthToken createToken(@Nonnull IAuthIdentification iAuthIdentification, @Nonnegative int n) {
        AuthToken authToken = new AuthToken(iAuthIdentification, n);
        String string = authToken.getID();
        s_aRWLock.writeLocked(() -> {
            if (s_aMap.containsKey(string)) {
                throw new IllegalArgumentException("Token '" + string + "' already contained");
            }
            s_aMap.put(string, authToken);
        });
        return authToken;
    }

    @Nonnull
    public static ESuccess removeToken(@Nonnull String string) {
        return s_aRWLock.writeLockedGet(() -> {
            AuthToken authToken = (AuthToken)s_aMap.remove(string);
            if (authToken == null) {
                return ESuccess.FAILURE;
            }
            authToken.setExpired();
            return ESuccess.SUCCESS;
        });
    }

    @Nullable
    private static AuthToken _getValidNotExpiredToken(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        AuthToken authToken = s_aRWLock.readLockedGet(() -> (AuthToken)s_aMap.get(string));
        return authToken != null && !authToken.isExpired() ? authToken : null;
    }

    @Nullable
    public static IAuthToken getValidToken(@Nullable String string) {
        return AuthTokenRegistry._getValidNotExpiredToken(string);
    }

    @Nullable
    public static IAuthToken validateTokenAndUpdateLastAccess(@Nullable String string) {
        AuthToken authToken = AuthTokenRegistry._getValidNotExpiredToken(string);
        if (authToken == null) {
            return null;
        }
        s_aRWLock.writeLocked(authToken::updateLastAccess);
        return authToken;
    }

    @Nonnull
    public static ICommonsList<IAuthToken> getAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull(iAuthSubject, "Subject");
        return s_aRWLock.readLockedGet(() -> CommonsArrayList.createFiltered(s_aMap.values(), iAuthToken -> iAuthToken.getIdentification().hasAuthSubject(iAuthSubject)));
    }

    @Nonnegative
    public static int removeAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull(iAuthSubject, "Subject");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        s_aRWLock.readLocked(() -> {
            for (Map.Entry entry : s_aMap.entrySet()) {
                if (!((AuthToken)entry.getValue()).getIdentification().hasAuthSubject(iAuthSubject)) continue;
                commonsArrayList.add(entry.getKey());
            }
        });
        for (String string : commonsArrayList) {
            AuthTokenRegistry.removeToken(string);
        }
        return commonsArrayList.size();
    }
}

