/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.ValueEnforcer;
import com.helger.security.authentication.credentials.AuthCredentialToSubjectResolverManager;
import com.helger.security.authentication.credentials.AuthCredentialValidatorManager;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.security.authentication.result.AuthIdentification;
import com.helger.security.authentication.result.AuthIdentificationResult;
import com.helger.security.authentication.result.AuthTokenRegistry;
import com.helger.security.authentication.result.IAuthToken;
import com.helger.security.authentication.subject.IAuthSubject;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AuthIdentificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthIdentificationManager.class);

    private AuthIdentificationManager() {
    }

    @Nonnull
    public static AuthIdentificationResult validateLoginCredentialsAndCreateToken(@Nonnull IAuthCredentials iAuthCredentials) {
        IAuthSubject iAuthSubject;
        ValueEnforcer.notNull(iAuthCredentials, "Credentials");
        ICredentialValidationResult iCredentialValidationResult = AuthCredentialValidatorManager.validateCredentials(iAuthCredentials);
        if (iCredentialValidationResult.isFailure()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Credentials have been rejected: " + iAuthCredentials);
            }
            return AuthIdentificationResult.createFailure(iCredentialValidationResult);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Credentials have been accepted: " + iAuthCredentials);
        }
        if ((iAuthSubject = AuthCredentialToSubjectResolverManager.getSubjectFromCredentials(iAuthCredentials)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Credentials " + iAuthCredentials + " correspond to subject " + iAuthSubject);
            }
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Failed to resolve credentials " + iAuthCredentials + " to an auth subject!");
        }
        AuthIdentification authIdentification = new AuthIdentification(iAuthSubject);
        IAuthToken iAuthToken = AuthTokenRegistry.createToken(authIdentification, 0);
        return AuthIdentificationResult.createSuccess(iAuthToken);
    }
}

