/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CredentialValidationResultList
implements ICredentialValidationResult {
    private final ICommonsList<ICredentialValidationResult> m_aResults;
    private final boolean m_bFailure;

    public CredentialValidationResultList(@Nonnull @Nonempty Iterable<? extends ICredentialValidationResult> iterable) {
        ValueEnforcer.notEmpty(iterable, "Results");
        this.m_aResults = new CommonsArrayList<Iterable<? extends ICredentialValidationResult>>(iterable);
        this.m_bFailure = this.m_aResults.containsAny(ISuccessIndicator::isFailure);
    }

    @Override
    public boolean isSuccess() {
        return !this.m_bFailure;
    }

    @Override
    public boolean isFailure() {
        return this.m_bFailure;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return StringHelper.getImplodedMapped('\n', this.m_aResults, iCredentialValidationResult -> iCredentialValidationResult.getDisplayText(locale));
    }

    public String toString() {
        return new ToStringGenerator(this).append("Results", this.m_aResults).append("Failure", this.m_bFailure).getToString();
    }
}

