/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.singleton;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SingletonHelper {
    public static final boolean DEFAULT_DEBUG_CONSISTENCY = GlobalDebug.isDebugMode();
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugConsistency = DEFAULT_DEBUG_CONSISTENCY;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugWithStackTrace = false;

    private SingletonHelper() {
    }

    public static void setDebugConsistency(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugConsistency = bl;
            return s_bDebugConsistency;
        });
    }

    public static boolean isDebugConsistency() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugConsistency);
    }

    public static void setDebugWithStackTrace(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugWithStackTrace = bl;
            return s_bDebugWithStackTrace;
        });
    }

    public static boolean isDebugWithStackTrace() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugWithStackTrace);
    }

    @Nullable
    public static Throwable getDebugStackTrace() {
        return SingletonHelper.isDebugWithStackTrace() ? new Exception() : null;
    }
}

