/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.EContinue;
import com.helger.scope.AbstractScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.ScopeHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionScope
extends AbstractScope
implements ISessionScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionScope.class);

    public SessionScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Created session scope '" + string + "'", ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugSessionScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroyed session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    public EContinue selfDestruct() {
        return EContinue.CONTINUE;
    }
}

