/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ScopeHelper {
    public static final boolean DEFAULT_DEBUG_LIFE_CYCLE = false;
    public static final boolean DEFAULT_DEBUG_GLOBAL_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_SESSION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_REQUEST_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugLifeCycle = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugGlobalScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugSessionScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugRequestScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugWithStackTrace = false;

    private ScopeHelper() {
    }

    public static void setLifeCycleDebuggingEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugLifeCycle = bl;
            return s_bDebugLifeCycle;
        });
    }

    public static boolean isLifeCycleDebuggingEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugLifeCycle);
    }

    public static void setDebugGlobalScopeEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugGlobalScope = bl;
            return s_bDebugGlobalScope;
        });
    }

    public static boolean isDebugGlobalScopeEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugGlobalScope);
    }

    public static void setDebugSessionScopeEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugSessionScope = bl;
            return s_bDebugSessionScope;
        });
    }

    public static boolean isDebugSessionScopeEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugSessionScope);
    }

    public static void setDebugRequestScopeEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugRequestScope = bl;
            return s_bDebugRequestScope;
        });
    }

    public static boolean isDebugRequestScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugRequestScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugWithStackTrace(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bDebugWithStackTrace = bl;
            return s_bDebugWithStackTrace;
        });
    }

    public static boolean isDebugWithStackTrace() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugWithStackTrace);
    }

    @Deprecated
    public static boolean debugGlobalScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugGlobalScopeLifeCycle(logger);
    }

    public static boolean isDebugGlobalScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugGlobalScopeEnabled()) && logger.isInfoEnabled();
    }

    @Deprecated
    public static boolean debugSessionScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugSessionScopeLifeCycle(logger);
    }

    public static boolean isDebugSessionScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugSessionScopeEnabled()) && logger.isInfoEnabled();
    }

    @Deprecated
    public static boolean debugRequestScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugRequestScopeLifeCycle(logger);
    }

    public static boolean isDebugRequestScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugRequestScopeEnabled()) && logger.isInfoEnabled();
    }

    @Nullable
    public static Throwable getDebugStackTrace() {
        return ScopeHelper.isDebugWithStackTrace() ? new DebugScopeException() : null;
    }

    public static class DebugScopeException
    extends Exception {
    }
}

