/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SchematronResourceXSLTCache;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SchematronResourceXSLT
extends AbstractSchematronXSLTBasedResource<SchematronResourceXSLT> {
    public SchematronResourceXSLT(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Override
    @Nullable
    public ISchematronXSLTBasedProvider getXSLTProvider() {
        if (this.isUseCache()) {
            return SchematronResourceXSLTCache.getSchematronXSLTProvider(this.getResource(), this.getErrorListener(), this.getURIResolver());
        }
        return SchematronResourceXSLTCache.createSchematronXSLTProvider(this.getResource(), this.getErrorListener(), this.getURIResolver());
    }

    @Nonnull
    public static SchematronResourceXSLT fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourceXSLT(new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourceXSLT fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourceXSLT(new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourceXSLT fromFile(@Nonnull File file) {
        return new SchematronResourceXSLT(new FileSystemResource(file));
    }
}

