/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.svrl.AbstractSVRLMessage;
import com.helger.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLLocationBeautifierRegistry;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.svrl.jaxb.SuccessfulReport;
import com.helger.schematron.svrl.jaxb.Text;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SVRLHelper {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLHelper s_aInstance = new SVRLHelper();

    private SVRLHelper() {
    }

    @Nullable
    public static String getAsString(@Nullable Text text) {
        if (text == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : text.getContent()) {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertions(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<SVRLFailedAssert> commonsArrayList = new CommonsArrayList<SVRLFailedAssert>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof FailedAssert)) continue;
                commonsArrayList.add(new SVRLFailedAssert((FailedAssert)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList<SVRLFailedAssert> commonsArrayList = new CommonsArrayList<SVRLFailedAssert>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLFailedAssert sVRLFailedAssert;
                if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add(sVRLFailedAssert);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<SVRLSuccessfulReport> commonsArrayList = new CommonsArrayList<SVRLSuccessfulReport>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList<SVRLSuccessfulReport> commonsArrayList = new CommonsArrayList<SVRLSuccessfulReport>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLSuccessfulReport sVRLSuccessfulReport;
                if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add(sVRLSuccessfulReport);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<AbstractSVRLMessage> getAllFailedAssertionsAndSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<AbstractSVRLMessage> commonsArrayList = new CommonsArrayList<AbstractSVRLMessage>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (object instanceof FailedAssert) {
                    commonsArrayList.add(new SVRLFailedAssert((FailedAssert)object));
                    continue;
                }
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    @Nonnull
    public static ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        return s_aRWLock.readLockedGet(() -> s_aELD);
    }

    public static void setErrorLevelDeterminator(@Nonnull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        ValueEnforcer.notNull(iSVRLErrorLevelDeterminator, "ErrorLevelDeterminator");
        s_aRWLock.writeLockedGet(() -> {
            s_aELD = iSVRLErrorLevelDeterminator;
            return s_aELD;
        });
    }

    @Nonnull
    public static String getBeautifiedLocation(@Nonnull String string) {
        String string2 = string;
        Matcher matcher = RegExHelper.getMatcher("\\Q*:\\E([a-zA-Z0-9_]+)\\Q[namespace-uri()='\\E([^']+)\\Q']\\E", string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = SVRLLocationBeautifierRegistry.getBeautifiedLocation(string4, string3);
            if (string5 == null) continue;
            string2 = StringHelper.replaceAll(string2, matcher.group(), string5);
        }
        return string2;
    }
}

