/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.StringHelper;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.om.NamespaceResolver;

public final class SaxonNamespaceContext
implements NamespaceContext,
NamespaceResolver {
    private final MapBasedNamespaceContext m_aCtx;

    public SaxonNamespaceContext(@Nonnull MapBasedNamespaceContext mapBasedNamespaceContext) {
        this.m_aCtx = ValueEnforcer.notNull(mapBasedNamespaceContext, "Ctx");
    }

    @Override
    @Nullable
    public String getURIForPrefix(@Nullable String string, boolean bl) {
        if (bl && StringHelper.hasNoText(string)) {
            return this.m_aCtx.getDefaultNamespaceURI();
        }
        return this.m_aCtx.getCustomNamespaceURI(string);
    }

    @Override
    @Nonnull
    public Iterator<String> iteratePrefixes() {
        CommonsArrayList commonsArrayList = new CommonsArrayList(this.m_aCtx.getPrefixToNamespaceURIMap().keySet());
        commonsArrayList.add("");
        return commonsArrayList.iterator();
    }

    @Override
    @Nonnull
    public String getNamespaceURI(@Nonnull String string) {
        return this.m_aCtx.getNamespaceURI(string);
    }

    @Override
    @Nullable
    public String getPrefix(@Nonnull String string) {
        return this.m_aCtx.getPrefix(string);
    }

    @Nonnull
    @DevelopersNote(value="Java 8: Iterator; Java 10: Iterator<String>")
    public Iterator getPrefixes(@Nonnull String string) {
        return this.m_aCtx.getPrefixes(string);
    }
}

