/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.validation;

import com.helger.commons.state.EContinue;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.validation.SchematronValidationException;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public interface IPSValidationHandler
extends Serializable {
    default public void onStart(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase, @Nullable String string) throws SchematronValidationException {
    }

    default public void onPattern(@Nonnull PSPattern pSPattern) throws SchematronValidationException {
    }

    default public void onRuleStart(@Nonnull PSRule pSRule, @Nonnull NodeList nodeList) throws SchematronValidationException {
    }

    default public void onFiredRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnegative int n, @Nonnegative int n2) throws SchematronValidationException {
    }

    @Nonnull
    default public EContinue onFailedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
        return EContinue.CONTINUE;
    }

    @Nonnull
    default public EContinue onSuccessfulReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
        return EContinue.CONTINUE;
    }

    default public void onEnd(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase) throws SchematronValidationException {
    }

    @Nonnull
    default public IPSValidationHandler and(@Nullable IPSValidationHandler iPSValidationHandler) {
        if (iPSValidationHandler == null) {
            return this;
        }
        return IPSValidationHandler.and(this, iPSValidationHandler);
    }

    @Nonnull
    public static IPSValidationHandler and(final @Nullable IPSValidationHandler iPSValidationHandler, final @Nullable IPSValidationHandler iPSValidationHandler2) {
        if (iPSValidationHandler == null) {
            return iPSValidationHandler2;
        }
        if (iPSValidationHandler2 == null) {
            return iPSValidationHandler;
        }
        return new IPSValidationHandler(){

            @Override
            public void onStart(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase, @Nullable String string) throws SchematronValidationException {
                iPSValidationHandler.onStart(pSSchema, pSPhase, string);
                iPSValidationHandler2.onStart(pSSchema, pSPhase, string);
            }

            @Override
            public void onPattern(@Nonnull PSPattern pSPattern) throws SchematronValidationException {
                iPSValidationHandler.onPattern(pSPattern);
                iPSValidationHandler2.onPattern(pSPattern);
            }

            @Override
            public void onRuleStart(@Nonnull PSRule pSRule, @Nonnull NodeList nodeList) throws SchematronValidationException {
                iPSValidationHandler.onRuleStart(pSRule, nodeList);
                iPSValidationHandler2.onRuleStart(pSRule, nodeList);
            }

            @Override
            public void onFiredRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnegative int n, @Nonnegative int n2) throws SchematronValidationException {
                iPSValidationHandler.onFiredRule(pSRule, string, n, n2);
                iPSValidationHandler2.onFiredRule(pSRule, string, n, n2);
            }

            @Override
            @Nonnull
            public EContinue onFailedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
                EContinue eContinue = iPSValidationHandler.onFailedAssert(pSAssertReport, string, node, n, object);
                if (eContinue.isContinue()) {
                    eContinue = iPSValidationHandler2.onFailedAssert(pSAssertReport, string, node, n, object);
                }
                return eContinue;
            }

            @Override
            @Nonnull
            public EContinue onSuccessfulReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
                EContinue eContinue = iPSValidationHandler.onSuccessfulReport(pSAssertReport, string, node, n, object);
                if (eContinue.isContinue()) {
                    eContinue = iPSValidationHandler2.onSuccessfulReport(pSAssertReport, string, node, n, object);
                }
                return eContinue;
            }

            @Override
            public void onEnd(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase) throws SchematronValidationException {
                iPSValidationHandler.onEnd(pSSchema, pSPhase);
                iPSValidationHandler2.onEnd(pSSchema, pSPhase);
            }
        };
    }
}

