/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSTitle
implements IPSClonableElement<PSTitle>,
IPSOptionalElement,
IPSHasMixedContent {
    private final ICommonsList<Object> m_aContent = new CommonsArrayList<Object>();

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(object -> object instanceof String);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull(pSDir, "Dir");
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "title");
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                microElement.appendText((String)e);
                continue;
            }
            microElement.appendChild(((IPSElement)e).getAsMicroElement());
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PSTitle getClone() {
        PSTitle pSTitle = new PSTitle();
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                pSTitle.addText((String)e);
                continue;
            }
            if (!(e instanceof PSDir)) continue;
            pSTitle.addDir(((PSDir)e).getClone());
        }
        return pSTitle;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).getToString();
    }
}

