/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPattern
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private boolean m_bAbstract = false;
    private String m_sID;
    private String m_sIsA;
    private PSRichGroup m_aRich;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList<Object>();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText(this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText(this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
            return false;
        }
        if (StringHelper.hasNoText(this.m_sIsA)) {
            for (Object e : this.m_aContent) {
                if (!(e instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
                return false;
            }
        } else {
            for (Object e : this.m_aContent) {
                if (e instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                    return false;
                }
                if (!(e instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
                return false;
            }
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText(this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
        }
        if (this.m_bAbstract && StringHelper.hasText(this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
        }
        if (StringHelper.hasNoText(this.m_sIsA)) {
            for (Object e : this.m_aContent) {
                if (!(e instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
            }
        } else {
            for (Object e : this.m_aContent) {
                if (e instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                }
                if (!(e instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
            }
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        if (this.m_bAbstract) {
            return false;
        }
        if (StringHelper.hasText(this.m_sIsA)) {
            return false;
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull(iMicroElement, "ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add(iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setIsA(@Nullable String string) {
        this.m_sIsA = string;
    }

    @Nullable
    public String getIsA() {
        return this.m_sIsA;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull(pSInclude, "Include");
        this.m_aContent.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aContent.containsAny(object -> object instanceof PSInclude);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return this.m_aContent.getAllInstanceOf(PSInclude.class);
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aContent.removeIf(object -> object instanceof PSTitle);
        if (pSTitle != null) {
            int n = -1;
            int n2 = 0;
            for (Object e : this.m_aContent) {
                if (e instanceof PSInclude) {
                    n = n2;
                }
                ++n2;
            }
            if (n < 0) {
                this.m_aContent.add(0, pSTitle);
            } else {
                this.m_aContent.add(n + 1, pSTitle);
            }
        }
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aContent.findFirstMapped(object -> object instanceof PSTitle, object -> (PSTitle)object);
    }

    public boolean hasTitle() {
        return this.m_aContent.containsAny(object -> object instanceof PSTitle);
    }

    public void addRule(@Nonnull PSRule pSRule) {
        ValueEnforcer.notNull(pSRule, "Rule");
        this.m_aContent.add(pSRule);
    }

    @Nullable
    public PSRule getRuleOfID(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (Object e : this.m_aContent) {
                PSRule pSRule;
                if (!(e instanceof PSRule) || !string.equals((pSRule = (PSRule)e).getID())) continue;
                return pSRule;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSRule> getAllRules() {
        return this.m_aContent.getAllInstanceOf(PSRule.class);
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aContent.getCount(object -> object instanceof PSRule);
    }

    public void addParam(@Nonnull PSParam pSParam) {
        ValueEnforcer.notNull(pSParam, "Param");
        this.m_aContent.add(pSParam);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSParam> getAllParams() {
        return this.m_aContent.getAllInstanceOf(PSParam.class);
    }

    public boolean hasAnyParam() {
        return this.m_aContent.containsAny(object -> object instanceof PSParam);
    }

    public void addP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull(pSP, "P");
        this.m_aContent.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllPs() {
        return this.m_aContent.getAllInstanceOf(PSP.class);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull(pSLet, "Let");
        this.m_aContent.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aContent.containsAny(object -> object instanceof PSLet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return this.m_aContent.getAllInstanceOf(PSLet.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (Object e : this.m_aContent) {
            if (!(e instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)e;
            commonsLinkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPSElement> getAllContentElements() {
        return this.m_aContent.getAllMapped(object -> object instanceof IPSElement && !(object instanceof PSInclude) && !(object instanceof PSTitle), object -> (IPSElement)object);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "pattern");
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("is-a", this.m_sIsA);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement(microElement);
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild(((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendChild(((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator(this).append("abstract", this.m_bAbstract).appendIfNotNull("id", this.m_sID).appendIfNotNull("is-a", this.m_sIsA).appendIfNotNull("rich", this.m_aRich).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

