/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasTexts;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDir
implements IPSClonableElement<PSDir>,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasTexts {
    private EDirValue m_eValue;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList<Object>();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<dir> has no content");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<dir> has no content");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull(iMicroElement, "ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add(iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    public void setValue(@Nullable EDirValue eDirValue) {
        this.m_eValue = eDirValue;
    }

    @Nullable
    public EDirValue getValue() {
        return this.m_eValue;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(object -> object instanceof String);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    @Nullable
    public String getAsText() {
        return StringHelper.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "dir");
        if (this.m_eValue != null) {
            microElement.setAttribute("value", this.m_eValue.getID());
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild(((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendText((String)object);
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PSDir getClone() {
        PSDir pSDir = new PSDir();
        pSDir.setValue(this.m_eValue);
        for (Object e : this.m_aContent) {
            if (e instanceof IMicroElement) {
                pSDir.addForeignElement(((IMicroElement)e).getClone());
                continue;
            }
            pSDir.addText((String)e);
        }
        if (this.hasForeignAttributes()) {
            pSDir.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSDir;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("value", this.m_eValue).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }

    public static enum EDirValue implements IHasID<String>
    {
        LTR("ltr"),
        RTL("rtl");

        private final String m_sID;

        private EDirValue(String string2) {
            this.m_sID = string2;
        }

        @Override
        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public static EDirValue getFromIDOrNull(@Nullable String string) {
            return EnumHelper.getFromIDOrNull(EDirValue.class, string);
        }
    }
}

