/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.exchange;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.SingleError;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronHelper;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.errorhandler.LoggingPSErrorHandler;
import com.helger.schematron.pure.exchange.SchematronReadException;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.PSActive;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSDiagnostics;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSExtends;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSLinkableGroup;
import com.helger.schematron.pure.model.PSNS;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.read.SAXReaderSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public class PSReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSReader.class);
    private final IReadableResource m_aResource;
    private final IPSErrorHandler m_aErrorHandler;
    private final EntityResolver m_aEntityResolver;
    private boolean m_bLenient = false;

    public PSReader(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, null, null);
    }

    public PSReader(@Nonnull IReadableResource iReadableResource, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable EntityResolver entityResolver) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        this.m_aResource = iReadableResource;
        this.m_aErrorHandler = iPSErrorHandler != null ? iPSErrorHandler : new LoggingPSErrorHandler();
        this.m_aEntityResolver = entityResolver;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    public final boolean isLenient() {
        return this.m_bLenient;
    }

    @Nonnull
    public final PSReader setLenient(boolean bl) {
        this.m_bLenient = bl;
        return this;
    }

    @Nullable
    private static String _getAttributeValue(@Nullable String string) {
        return string == null ? null : string.trim();
    }

    private void _warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        ValueEnforcer.notNull(iPSElement, "SourceElement");
        ValueEnforcer.notNull(string, "Message");
        this.m_aErrorHandler.handleError(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderWarn().setErrorLocation(new SimpleLocation(this.m_aResource.getPath()))).setErrorFieldName(IPSErrorHandler.getErrorFieldName(iPSElement))).setErrorText(string)).build());
    }

    @Nonnull
    public PSActive readActiveFromXML(@Nonnull IMicroElement iMicroElement) {
        PSActive pSActive = new PSActive();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("pattern")) {
                pSActive.setPattern(string4);
            } else {
                pSActive.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSActive.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        String string = iMicroElement.getLocalName();
                        if (string.equals("dir")) {
                            pSActive.addDir(this.readDirFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("emph")) {
                            pSActive.addEmph(this.readEmphFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("span")) {
                            pSActive.addSpan(this.readSpanFromXML(iMicroElement));
                            break;
                        }
                        this._warn(pSActive, "Unsupported Schematron element '" + string + "'");
                        break;
                    }
                    pSActive.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSActive, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSActive;
    }

    private void _handleRichGroup(@Nonnull String string, @Nonnull String string2, @Nonnull PSRichGroup pSRichGroup) {
        if (string.equals("icon")) {
            pSRichGroup.setIcon(string2);
        } else if (string.equals("see")) {
            pSRichGroup.setSee(string2);
        } else if (string.equals("fpi")) {
            pSRichGroup.setFPI(string2);
        } else if (string.equals("lang")) {
            pSRichGroup.setXmlLang(string2);
        } else if (string.equals("space")) {
            pSRichGroup.setXmlSpace(PSRichGroup.ESpace.getFromIDOrNull(string2));
        }
    }

    private void _handleLinkableGroup(@Nonnull String string, @Nonnull String string2, @Nonnull PSLinkableGroup pSLinkableGroup) {
        if (string.equals("role")) {
            pSLinkableGroup.setRole(string2);
        } else if (string.equals("subject")) {
            pSLinkableGroup.setSubject(string2);
        }
    }

    @Nonnull
    public PSAssertReport readAssertReportFromXML(@Nonnull IMicroElement iMicroElement) {
        PSAssertReport pSAssertReport = new PSAssertReport(iMicroElement.getLocalName().equals("assert"));
        PSRichGroup pSRichGroup = new PSRichGroup();
        PSLinkableGroup pSLinkableGroup = new PSLinkableGroup();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("test")) {
                pSAssertReport.setTest(string4);
            } else if (string2.equals("flag")) {
                pSAssertReport.setFlag(string4);
            } else if (string2.equals("id")) {
                pSAssertReport.setID(string4);
            } else if (string2.equals("diagnostics")) {
                pSAssertReport.setDiagnostics(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else if (PSLinkableGroup.isLinkableAttribute(string2)) {
                this._handleLinkableGroup((String)string2, string4, pSLinkableGroup);
            } else {
                pSAssertReport.addForeignAttribute((String)string2, string4);
            }
        });
        pSAssertReport.setRich(pSRichGroup);
        pSAssertReport.setLinkable(pSLinkableGroup);
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSAssertReport.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        String string = iMicroElement.getLocalName();
                        if (string.equals("name")) {
                            pSAssertReport.addName(this.readNameFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("value-of")) {
                            pSAssertReport.addValueOf(this.readValueOfFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("emph")) {
                            pSAssertReport.addEmph(this.readEmphFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("dir")) {
                            pSAssertReport.addDir(this.readDirFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("span")) {
                            pSAssertReport.addSpan(this.readSpanFromXML(iMicroElement));
                            break;
                        }
                        this._warn(pSAssertReport, "Unsupported Schematron element '" + string + "'");
                        break;
                    }
                    pSAssertReport.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSAssertReport, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSAssertReport;
    }

    @Nonnull
    public PSDiagnostic readDiagnosticFromXML(@Nonnull IMicroElement iMicroElement) {
        PSDiagnostic pSDiagnostic = new PSDiagnostic();
        PSRichGroup pSRichGroup = new PSRichGroup();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("id")) {
                pSDiagnostic.setID(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else {
                pSDiagnostic.addForeignAttribute((String)string2, string4);
            }
        });
        pSDiagnostic.setRich(pSRichGroup);
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSDiagnostic.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        String string = iMicroElement.getLocalName();
                        if (string.equals("value-of")) {
                            pSDiagnostic.addValueOf(this.readValueOfFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("emph")) {
                            pSDiagnostic.addEmph(this.readEmphFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("dir")) {
                            pSDiagnostic.addDir(this.readDirFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("span")) {
                            pSDiagnostic.addSpan(this.readSpanFromXML(iMicroElement));
                            break;
                        }
                        this._warn(pSDiagnostic, "Unsupported Schematron element '" + string + "'");
                        break;
                    }
                    pSDiagnostic.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSDiagnostic, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSDiagnostic;
    }

    @Nonnull
    public PSDiagnostics readDiagnosticsFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSDiagnostics pSDiagnostics = new PSDiagnostics();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            pSDiagnostics.addForeignAttribute((String)string2, string4);
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                if (iMicroElement.getLocalName().equals("include")) {
                    pSDiagnostics.addInclude(this.readIncludeFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("diagnostic")) {
                    pSDiagnostics.addDiagnostic(this.readDiagnosticFromXML((IMicroElement)iMicroElement));
                } else {
                    this._warn(pSDiagnostics, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                }
            } else {
                pSDiagnostics.addForeignElement(iMicroElement.getClone());
            }
        });
        return pSDiagnostics;
    }

    @Nonnull
    public PSDir readDirFromXML(@Nonnull IMicroElement iMicroElement) {
        PSDir pSDir = new PSDir();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("value")) {
                pSDir.setValue(PSDir.EDirValue.getFromIDOrNull(string4));
            } else {
                pSDir.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSDir.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        this._warn(pSDir, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                        break;
                    }
                    pSDir.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSDir, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSDir;
    }

    @Nonnull
    public PSEmph readEmphFromXML(@Nonnull IMicroElement iMicroElement) {
        PSEmph pSEmph = new PSEmph();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            this._warn(pSEmph, "Unsupported attribute '" + string2 + "'='" + string4 + "'");
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSEmph.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        this._warn(pSEmph, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                        break;
                    }
                    this._warn(pSEmph, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSEmph, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSEmph;
    }

    @Nonnull
    public PSExtends readExtendsFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSExtends pSExtends = new PSExtends();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("rule")) {
                pSExtends.setRule(string4);
            } else {
                pSExtends.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSExtends, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSExtends, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSExtends;
    }

    @Nonnull
    public PSInclude readIncludeFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSInclude pSInclude = new PSInclude();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("href")) {
                pSInclude.setHref(string4);
            } else {
                this._warn(pSInclude, "Unsupported attribute '" + string2 + "'='" + string4 + "'");
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSInclude, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSInclude, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSInclude;
    }

    @Nonnull
    public PSLet readLetFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSLet pSLet = new PSLet();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("name")) {
                pSLet.setName(string4);
            } else if (string2.equals("value")) {
                pSLet.setValue(string4);
            } else {
                this._warn(pSLet, "Unsupported attribute '" + string2 + "'='" + string4 + "'");
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSLet, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSLet, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSLet;
    }

    @Nonnull
    public PSName readNameFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSName pSName = new PSName();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("path")) {
                pSName.setPath(string4);
            } else {
                pSName.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSName, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSName, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSName;
    }

    @Nonnull
    public PSNS readNSFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSNS pSNS = new PSNS();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("uri")) {
                pSNS.setUri(string4);
            } else if (string2.equals("prefix")) {
                pSNS.setPrefix(string4);
            } else {
                pSNS.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSNS, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSNS, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSNS;
    }

    @Nonnull
    public PSP readPFromXML(@Nonnull IMicroElement iMicroElement) {
        PSP pSP = new PSP();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("id")) {
                pSP.setID(string4);
            } else if (string2.equals("class")) {
                pSP.setClazz(string4);
            } else if (string2.equals("icon")) {
                pSP.setIcon(string4);
            } else {
                pSP.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSP.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        String string = iMicroElement.getLocalName();
                        if (string.equals("dir")) {
                            pSP.addDir(this.readDirFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("emph")) {
                            pSP.addEmph(this.readEmphFromXML(iMicroElement));
                            break;
                        }
                        if (string.equals("span")) {
                            pSP.addSpan(this.readSpanFromXML(iMicroElement));
                            break;
                        }
                        this._warn(pSP, "Unsupported Schematron element '" + string + "'");
                        break;
                    }
                    pSP.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSP, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSP;
    }

    @Nonnull
    public PSParam readParamFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSParam pSParam = new PSParam();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("name")) {
                pSParam.setName(string4);
            } else if (string2.equals("value")) {
                pSParam.setValue(string4);
            } else {
                this._warn(pSParam, "Unsupported attribute '" + string2 + "'='" + string4 + "'");
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSParam, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSParam, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSParam;
    }

    @Nonnull
    public PSPattern readPatternFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSPattern pSPattern = new PSPattern();
        PSRichGroup pSRichGroup = new PSRichGroup();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("abstract")) {
                pSPattern.setAbstract(StringParser.parseBool(string4));
            } else if (string2.equals("id")) {
                pSPattern.setID(string4);
            } else if (string2.equals("is-a")) {
                pSPattern.setIsA(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else {
                pSPattern.addForeignAttribute((String)string2, string4);
            }
        });
        pSPattern.setRich(pSRichGroup);
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                if (iMicroElement.getLocalName().equals("include")) {
                    pSPattern.addInclude(this.readIncludeFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("title")) {
                    pSPattern.setTitle(this.readTitleFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("p")) {
                    pSPattern.addP(this.readPFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("let")) {
                    pSPattern.addLet(this.readLetFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("rule")) {
                    pSPattern.addRule(this.readRuleFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("param")) {
                    pSPattern.addParam(this.readParamFromXML((IMicroElement)iMicroElement));
                } else {
                    this._warn(pSPattern, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "' in " + pSPattern.toString());
                }
            } else {
                pSPattern.addForeignElement(iMicroElement.getClone());
            }
        });
        return pSPattern;
    }

    @Nonnull
    public PSPhase readPhaseFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSPhase pSPhase = new PSPhase();
        PSRichGroup pSRichGroup = new PSRichGroup();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("id")) {
                pSPhase.setID(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else {
                pSPhase.addForeignAttribute((String)string2, string4);
            }
        });
        pSPhase.setRich(pSRichGroup);
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                if (iMicroElement.getLocalName().equals("include")) {
                    pSPhase.addInclude(this.readIncludeFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("p")) {
                    pSPhase.addP(this.readPFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("let")) {
                    pSPhase.addLet(this.readLetFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("active")) {
                    pSPhase.addActive(this.readActiveFromXML((IMicroElement)iMicroElement));
                } else {
                    this._warn(pSPhase, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                }
            } else {
                pSPhase.addForeignElement(iMicroElement.getClone());
            }
        });
        return pSPhase;
    }

    @Nonnull
    public PSRule readRuleFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSRule pSRule = new PSRule();
        PSRichGroup pSRichGroup = new PSRichGroup();
        PSLinkableGroup pSLinkableGroup = new PSLinkableGroup();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("flag")) {
                pSRule.setFlag(string4);
            } else if (string2.equals("abstract")) {
                pSRule.setAbstract(StringParser.parseBool(string4));
            } else if (string2.equals("context")) {
                pSRule.setContext(string4);
            } else if (string2.equals("id")) {
                pSRule.setID(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else if (PSLinkableGroup.isLinkableAttribute(string2)) {
                this._handleLinkableGroup((String)string2, string4, pSLinkableGroup);
            } else {
                pSRule.addForeignAttribute((String)string2, string4);
            }
        });
        pSRule.setRich(pSRichGroup);
        pSRule.setLinkable(pSLinkableGroup);
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                String string = iMicroElement.getLocalName();
                if (string.equals("include")) {
                    pSRule.addInclude(this.readIncludeFromXML((IMicroElement)iMicroElement));
                } else if (string.equals("let")) {
                    pSRule.addLet(this.readLetFromXML((IMicroElement)iMicroElement));
                } else if (string.equals("assert") || string.equals("report")) {
                    pSRule.addAssertReport(this.readAssertReportFromXML((IMicroElement)iMicroElement));
                } else if (string.equals("extends")) {
                    pSRule.addExtends(this.readExtendsFromXML((IMicroElement)iMicroElement));
                } else {
                    this._warn(pSRule, "Unsupported Schematron element '" + string + "'");
                }
            } else {
                pSRule.addForeignElement(iMicroElement.getClone());
            }
        });
        return pSRule;
    }

    public boolean isValidSchematronNS(@Nullable String string) {
        return SchematronHelper.isValidSchematronNS(string, this.isLenient());
    }

    @Nonnull
    public PSSchema readSchemaFromXML(@Nonnull IMicroElement iMicroElement2) throws SchematronReadException {
        ValueEnforcer.notNull(iMicroElement2, "Schema");
        if (!this.isLenient() && SchematronHelper.isDeprecatedSchematronNS(iMicroElement2.getNamespaceURI())) {
            LOGGER.warn("OLD Schematron NS '" + iMicroElement2.getNamespaceURI() + "' is deprecated, use '" + "http://purl.oclc.org/dsdl/schematron" + "' instead");
        }
        if (!this.isValidSchematronNS(iMicroElement2.getNamespaceURI())) {
            throw new SchematronReadException(this.m_aResource, "The passed element is not an ISO Schematron element!");
        }
        PSSchema pSSchema = new PSSchema(this.m_aResource);
        PSRichGroup pSRichGroup = new PSRichGroup();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("id")) {
                pSSchema.setID(string4);
            } else if (string2.equals("schemaVersion")) {
                pSSchema.setSchemaVersion(string4);
            } else if (string2.equals("defaultPhase")) {
                pSSchema.setDefaultPhase(string4);
            } else if (string2.equals("queryBinding")) {
                pSSchema.setQueryBinding(string4);
            } else if (PSRichGroup.isRichAttribute(string2)) {
                this._handleRichGroup((String)string2, string4, pSRichGroup);
            } else {
                pSSchema.addForeignAttribute((String)string2, string4);
            }
        });
        pSSchema.setRich(pSRichGroup);
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                if (iMicroElement.getLocalName().equals("include")) {
                    pSSchema.addInclude(this.readIncludeFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("title")) {
                    pSSchema.setTitle(this.readTitleFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("ns")) {
                    pSSchema.addNS(this.readNSFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("p")) {
                    PSP pSP = this.readPFromXML((IMicroElement)iMicroElement);
                    if (pSSchema.hasNoPatterns()) {
                        pSSchema.addStartP(pSP);
                    } else {
                        pSSchema.addEndP(pSP);
                    }
                } else if (iMicroElement.getLocalName().equals("let")) {
                    pSSchema.addLet(this.readLetFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("phase")) {
                    pSSchema.addPhase(this.readPhaseFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("pattern")) {
                    pSSchema.addPattern(this.readPatternFromXML((IMicroElement)iMicroElement));
                } else if (iMicroElement.getLocalName().equals("diagnostics")) {
                    pSSchema.setDiagnostics(this.readDiagnosticsFromXML((IMicroElement)iMicroElement));
                } else {
                    this._warn(pSSchema, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                }
            } else {
                pSSchema.addForeignElement(iMicroElement.getClone());
            }
        });
        return pSSchema;
    }

    @Nonnull
    public PSSpan readSpanFromXML(@Nonnull IMicroElement iMicroElement) {
        PSSpan pSSpan = new PSSpan();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("class")) {
                pSSpan.setClazz(string4);
            } else {
                pSSpan.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSSpan.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        this._warn(pSSpan, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
                        break;
                    }
                    pSSpan.addForeignElement(iMicroElement.getClone());
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSSpan, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSSpan;
    }

    @Nonnull
    public PSTitle readTitleFromXML(@Nonnull IMicroElement iMicroElement) {
        PSTitle pSTitle = new PSTitle();
        iMicroElement.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            this._warn(pSTitle, "Unsupported attribute '" + string2 + "'='" + string4 + "'");
        });
        iMicroElement.forAllChildren(iMicroNode -> {
            switch (iMicroNode.getType()) {
                case TEXT: {
                    pSTitle.addText(((IMicroText)iMicroNode).getNodeValue());
                    break;
                }
                case ELEMENT: {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                        String string = iMicroElement.getLocalName();
                        if (string.equals("dir")) {
                            pSTitle.addDir(this.readDirFromXML(iMicroElement));
                            break;
                        }
                        this._warn(pSTitle, "Unsupported Schematron element '" + string + "'");
                        break;
                    }
                    this._warn(pSTitle, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    this._warn(pSTitle, "Unsupported child node: " + iMicroNode);
                }
            }
        });
        return pSTitle;
    }

    @Nonnull
    public PSValueOf readValueOfFromXML(@Nonnull IMicroElement iMicroElement2) {
        PSValueOf pSValueOf = new PSValueOf();
        iMicroElement2.forAllAttributes((string, string2, string3) -> {
            String string4 = PSReader._getAttributeValue(string3);
            if (string2.equals("select")) {
                pSValueOf.setSelect(string4);
            } else {
                pSValueOf.addForeignAttribute((String)string2, string4);
            }
        });
        iMicroElement2.forAllChildElements(iMicroElement -> {
            if (this.isValidSchematronNS(iMicroElement.getNamespaceURI())) {
                this._warn(pSValueOf, "Unsupported Schematron element '" + iMicroElement.getLocalName() + "'");
            } else {
                this._warn(pSValueOf, "Unsupported namespace URI '" + iMicroElement.getNamespaceURI() + "'");
            }
        });
        return pSValueOf;
    }

    @Nonnull
    public PSSchema readSchema() throws SchematronReadException {
        SAXReaderSettings sAXReaderSettings = new SAXReaderSettings().setEntityResolver(this.m_aEntityResolver);
        IMicroDocument iMicroDocument = SchematronHelper.getWithResolvedSchematronIncludes(this.m_aResource, sAXReaderSettings, this.m_aErrorHandler, this.m_bLenient);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            throw new SchematronReadException(this.m_aResource, "Failed to resolve includes in Schematron resource " + this.m_aResource);
        }
        if (SchematronDebug.isShowResolvedSourceSchematron()) {
            LOGGER.info("Resolved source Schematron:\n" + MicroWriter.getNodeAsString(iMicroDocument));
        }
        return this.readSchemaFromXML(iMicroDocument.getDocumentElement());
    }

    public String toString() {
        return new ToStringGenerator(this).append("resource", this.m_aResource).append("errorHandler", this.m_aErrorHandler).getToString();
    }
}

