/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.simple.doctype;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.simple.doctype.IBusdoxDocumentTypeIdentifierParts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BusdoxDocumentTypeIdentifierParts
implements IBusdoxDocumentTypeIdentifierParts {
    private final String m_sRootNS;
    private final String m_sLocalName;
    private final String m_sSubTypeIdentifier;

    public BusdoxDocumentTypeIdentifierParts(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        ValueEnforcer.notEmpty(string, "RootNS");
        ValueEnforcer.notEmpty(string2, "LocalName");
        this.m_sRootNS = string;
        this.m_sLocalName = string2;
        this.m_sSubTypeIdentifier = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getRootNS() {
        return this.m_sRootNS;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    @Nullable
    public String getSubTypeIdentifier() {
        return this.m_sSubTypeIdentifier;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsDocumentTypeIdentifierValue() {
        return BusdoxDocumentTypeIdentifierParts.getAsDocumentTypeIdentifierValue(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BusdoxDocumentTypeIdentifierParts busdoxDocumentTypeIdentifierParts = (BusdoxDocumentTypeIdentifierParts)object;
        return this.m_sRootNS.equals(busdoxDocumentTypeIdentifierParts.m_sRootNS) && this.m_sLocalName.equals(busdoxDocumentTypeIdentifierParts.m_sLocalName) && EqualsHelper.equals(this.m_sSubTypeIdentifier, busdoxDocumentTypeIdentifierParts.m_sSubTypeIdentifier);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sRootNS).append(this.m_sLocalName).append(this.m_sSubTypeIdentifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("rootNS", this.m_sRootNS).append("localName", this.m_sLocalName).append("subTypeIdentifier", this.m_sSubTypeIdentifier).getToString();
    }

    @Nonnull
    @Nonempty
    public static String getAsDocumentTypeIdentifierValue(@Nonnull IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts) {
        ValueEnforcer.notNull(iBusdoxDocumentTypeIdentifierParts, "Parts");
        String string = iBusdoxDocumentTypeIdentifierParts.getRootNS() + "::" + iBusdoxDocumentTypeIdentifierParts.getLocalName();
        String string2 = iBusdoxDocumentTypeIdentifierParts.getSubTypeIdentifier();
        if (StringHelper.hasText(string2)) {
            string = string + "##" + string2;
        }
        return string;
    }

    @Nonnull
    public static IBusdoxDocumentTypeIdentifierParts extractFromString(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DocumentTypeIdentifier");
        ICommonsList<String> iCommonsList = StringHelper.getExploded("##", string, 2);
        ICommonsList<String> iCommonsList2 = StringHelper.getExploded("::", (String)iCommonsList.get(0), 2);
        if (iCommonsList2.size() < 2) {
            throw new IllegalArgumentException("The document identifier '" + string + "' is missing the separation between root namespace and local name!");
        }
        String string2 = (String)iCommonsList2.get(0);
        String string3 = (String)iCommonsList2.get(1);
        String string4 = iCommonsList.size() == 1 ? null : (String)iCommonsList.get(1);
        return new BusdoxDocumentTypeIdentifierParts(string2, string3, string4);
    }
}

