/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PeppolIdentifierHelper {
    public static final int MAX_IDENTIFIER_SCHEME_LENGTH = 25;
    public static final String DNS_HASHED_IDENTIFIER_PREFIX = "B-";
    public static final boolean DEFAULT_CHARSET_CHECKS_DISABLED = false;
    public static final boolean DEFAULT_SCHEME_MAX_LENGTH_CHECKS_DISABLED = false;
    public static final String PARTICIPANT_IDENTIFIER_SCHEME_REGEX = "[a-z0-9]+-[a-z0-9]+-[a-z0-9]+";
    private static final AtomicBoolean s_aCharsetChecksDisabled = new AtomicBoolean(false);
    private static final AtomicBoolean s_aSchemeMaxLengthChecksDisabled = new AtomicBoolean(false);
    public static final String DEFAULT_DOCUMENT_TYPE_SCHEME = "busdox-docid-qns";
    public static final int MAX_DOCUEMNT_TYPE_VALUE_LENGTH = 500;
    public static final String DEFAULT_PARTICIPANT_SCHEME = "iso6523-actorid-upis";
    public static final int MAX_PARTICIPANT_VALUE_LENGTH = 50;
    public static final String DEFAULT_PROCESS_SCHEME = "cenbii-procid-ubl";
    public static final int MAX_PROCESS_VALUE_LENGTH = 200;
    private static final PeppolIdentifierHelper s_aInstance = new PeppolIdentifierHelper();

    private PeppolIdentifierHelper() {
    }

    public static boolean areCharsetChecksDisabled() {
        return s_aCharsetChecksDisabled.get();
    }

    public static void disableCharsetChecks(boolean bl) {
        s_aCharsetChecksDisabled.set(bl);
    }

    public static boolean areSchemeMaxLengthChecksDisabled() {
        return s_aSchemeMaxLengthChecksDisabled.get();
    }

    public static void disableSchemeMaxLengthChecks(boolean bl) {
        s_aSchemeMaxLengthChecksDisabled.set(bl);
    }

    public static boolean isValidIdentifierScheme(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (string.indexOf("::") >= 0) {
            return false;
        }
        if (PeppolIdentifierHelper.areSchemeMaxLengthChecksDisabled()) {
            return true;
        }
        return n <= 25;
    }
}

