/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PeppolKeyStoreHelper {
    public static final EKeyStoreType TRUSTSTORE_TYPE = EKeyStoreType.JKS;
    public static final String TRUSTSTORE_COMPLETE_CLASSPATH = "truststore/complete-truststore.jks";
    public static final String TRUSTSTORE_PASSWORD = "peppol";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolKeyStoreHelper.class);
    private static final PeppolKeyStoreHelper s_aInstance = new PeppolKeyStoreHelper();

    @Nullable
    private static X509Certificate _resolveCert(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string) {
        try {
            return (X509Certificate)keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to resolve alias '" + string + "' in trust store.", keyStoreException);
            return null;
        }
    }

    private PeppolKeyStoreHelper() {
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKeyStore loadedKeyStore) {
        return loadedKeyStore == null ? null : loadedKeyStore.getErrorText(TextHelper.EN);
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKey<?> loadedKey) {
        return loadedKey == null ? null : loadedKey.getErrorText(TextHelper.EN);
    }

    static /* synthetic */ X509Certificate access$000(KeyStore keyStore, String string) {
        return PeppolKeyStoreHelper._resolveCert(keyStore, string);
    }

    @Immutable
    public static final class Config2018 {
        public static final String TRUSTSTORE_PRODUCTION_CLASSPATH = "truststore/2018/prod-truststore.jks";
        private static final KeyStore TRUSTSTORE_PRODUCTION = KeyStoreHelper.loadKeyStore(TRUSTSTORE_TYPE, "truststore/2018/prod-truststore.jks", "peppol").getKeyStore();
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca - g2";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol root ca - g2");
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol access point ca - g2 (peppol root ca - g2)");
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol service metadata publisher ca - g2 (peppol root ca - g2)");
        public static final String TRUSTSTORE_PILOT_CLASSPATH = "truststore/2018/pilot-truststore.jks";
        private static final KeyStore TRUSTSTORE_PILOT = KeyStoreHelper.loadKeyStore(TRUSTSTORE_TYPE, "truststore/2018/pilot-truststore.jks", "peppol").getKeyStore();
        public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca - g2";
        public static final X509Certificate CERTIFICATE_PILOT_ROOT = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol root test ca - g2");
        public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_AP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol access point test ca - g2 (peppol root test ca - g2)");
        public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_SMP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol service metadata publisher test ca - g2 (peppol root test ca - g2)");

        private Config2018() {
        }
    }

    @Deprecated
    @Immutable
    public static final class Config2010 {
        public static final String TRUSTSTORE_PRODUCTION_CLASSPATH = "truststore/2010/prod-truststore.jks";
        private static final KeyStore TRUSTSTORE_PRODUCTION = KeyStoreHelper.loadKeyStore(TRUSTSTORE_TYPE, "truststore/2010/prod-truststore.jks", "peppol").getKeyStore();
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol root ca");
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca (peppol root ca)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol access point ca (peppol root ca)");
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca (peppol root ca)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PRODUCTION, "peppol service metadata publisher ca (peppol root ca)");
        public static final String TRUSTSTORE_PILOT_CLASSPATH = "truststore/2010/pilot-truststore.jks";
        private static final KeyStore TRUSTSTORE_PILOT = KeyStoreHelper.loadKeyStore(TRUSTSTORE_TYPE, "truststore/2010/pilot-truststore.jks", "peppol").getKeyStore();
        public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca";
        public static final X509Certificate CERTIFICATE_PILOT_ROOT = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol root test ca");
        public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca (peppol root test ca)";
        public static final X509Certificate CERTIFICATE_PILOT_AP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol access point test ca (peppol root test ca)");
        public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca (peppol root test ca)";
        public static final X509Certificate CERTIFICATE_PILOT_SMP = PeppolKeyStoreHelper.access$000(TRUSTSTORE_PILOT, "peppol service metadata publisher test ca (peppol root test ca)");

        private Config2010() {
        }
    }
}

