/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.codelist;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasDisplayName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ETaxCategoryID implements IHasID<String>,
IHasDisplayName
{
    MIXED_TAX_RATE("A", "Mixed tax rate"),
    LOWER_RATE("AA", "Lower rate"),
    EXEMPT_FOR_RESALE("AB", "Exempt for resale"),
    VALUE_ADDED_TAX_VAT_NOT_NOW_DUE_FOR_PAYMENT("AC", "Value Added Tax (VAT) not now due for payment"),
    VALUE_ADDED_TAX_VAT_DUE_FROM_A_PREVIOUS_INVOICE("AD", "Value Added Tax (VAT) due from a previous invoice"),
    VAT_REVERSE_CHARGE("AE", "VAT Reverse Charge"),
    TRANSFERRED_VAT_("B", "Transferred (VAT)"),
    DUTY_PAID_BY_SUPPLIER("C", "Duty paid by supplier"),
    EXEMPT_FROM_TAX("E", "Exempt from tax"),
    FREE_EXPORT_ITEM_TAX_NOT_CHARGED("G", "Free export item, tax not charged"),
    HIGHER_RATE("H", "Higher rate"),
    SERVICES_OUTSIDE_SCOPE_OF_TAX("O", "Services outside scope of tax"),
    STANDARD_RATE("S", "Standard rate"),
    ZERO_RATED_GOODS("Z", "Zero rated goods");

    private final String m_sID;
    private final String m_sDisplayName;

    private ETaxCategoryID(String string2, String string3) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nullable
    public static ETaxCategoryID getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ETaxCategoryID.class, string);
    }

    @Nullable
    public static String getDisplayNameFromIDOrNull(@Nullable String string) {
        ETaxCategoryID eTaxCategoryID = ETaxCategoryID.getFromIDOrNull(string);
        return eTaxCategoryID == null ? null : eTaxCategoryID.getDisplayName();
    }
}

