/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v3;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.v3.PD3BusinessEntityType;
import com.helger.pd.businesscard.v3.PD3IdentifierType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessCardType", propOrder={"participantIdentifier", "businessEntity"})
@CodingStyleguideUnaware
public class PD3BusinessCardType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="ParticipantIdentifier", required=true)
    private PD3IdentifierType participantIdentifier;
    @XmlElement(name="BusinessEntity")
    private List<PD3BusinessEntityType> businessEntity;

    @Nullable
    public PD3IdentifierType getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public void setParticipantIdentifier(@Nullable PD3IdentifierType pD3IdentifierType) {
        this.participantIdentifier = pD3IdentifierType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PD3BusinessEntityType> getBusinessEntity() {
        if (this.businessEntity == null) {
            this.businessEntity = new ArrayList<PD3BusinessEntityType>();
        }
        return this.businessEntity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PD3BusinessCardType pD3BusinessCardType = (PD3BusinessCardType)object;
        if (!EqualsHelper.equalsCollection(this.businessEntity, pD3BusinessCardType.businessEntity)) {
            return false;
        }
        return EqualsHelper.equals(this.participantIdentifier, pD3BusinessCardType.participantIdentifier);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.businessEntity)).append(this.participantIdentifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("businessEntity", this.businessEntity).append("participantIdentifier", this.participantIdentifier).getToString();
    }

    public void setBusinessEntity(@Nullable List<PD3BusinessEntityType> list) {
        this.businessEntity = list;
    }

    public boolean hasBusinessEntityEntries() {
        return !this.getBusinessEntity().isEmpty();
    }

    public boolean hasNoBusinessEntityEntries() {
        return this.getBusinessEntity().isEmpty();
    }

    @Nonnegative
    public int getBusinessEntityCount() {
        return this.getBusinessEntity().size();
    }

    @Nullable
    public PD3BusinessEntityType getBusinessEntityAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getBusinessEntity().get(n);
    }

    public void addBusinessEntity(@Nonnull PD3BusinessEntityType pD3BusinessEntityType) {
        this.getBusinessEntity().add(pD3BusinessEntityType);
    }

    public void cloneTo(@Nonnull PD3BusinessCardType pD3BusinessCardType) {
        if (this.businessEntity == null) {
            pD3BusinessCardType.businessEntity = null;
        } else {
            ArrayList<PD3BusinessEntityType> arrayList = new ArrayList<PD3BusinessEntityType>();
            for (PD3BusinessEntityType pD3BusinessEntityType : this.getBusinessEntity()) {
                arrayList.add(pD3BusinessEntityType == null ? null : pD3BusinessEntityType.clone());
            }
            pD3BusinessCardType.businessEntity = arrayList;
        }
        pD3BusinessCardType.participantIdentifier = this.participantIdentifier == null ? null : this.participantIdentifier.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PD3BusinessCardType clone() {
        PD3BusinessCardType pD3BusinessCardType = new PD3BusinessCardType();
        this.cloneTo(pD3BusinessCardType);
        return pD3BusinessCardType;
    }
}

