/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EHandled;
import com.helger.network.proxy.settings.IProxySettings;
import com.helger.network.proxy.settings.IProxySettingsProvider;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ProxySettingsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySettingsManager.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsList<IProxySettingsProvider> s_aList = new CommonsArrayList<IProxySettingsProvider>();

    private ProxySettingsManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IProxySettingsProvider> getAllProviders() {
        return s_aRWLock.readLockedGet(s_aList::getClone);
    }

    public static void registerProvider(@Nonnull IProxySettingsProvider iProxySettingsProvider) {
        ValueEnforcer.notNull(iProxySettingsProvider, "Provider");
        s_aRWLock.writeLockedBoolean(() -> s_aList.add(iProxySettingsProvider));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registered proxy settings provider " + iProxySettingsProvider);
        }
    }

    @Nonnull
    public static EChange unregisterProvider(@Nullable IProxySettingsProvider iProxySettingsProvider) {
        if (iProxySettingsProvider == null) {
            return EChange.UNCHANGED;
        }
        EChange eChange = s_aRWLock.writeLockedGet(() -> s_aList.removeObject(iProxySettingsProvider));
        if (eChange.isChanged() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Unregistered proxy settings provider " + iProxySettingsProvider);
        }
        return eChange;
    }

    @Nonnull
    public static EChange removeAllProviders() {
        EChange eChange = s_aRWLock.writeLockedGet(s_aList::removeAll);
        if (eChange.isChanged() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Removed all proxy settings provider");
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IProxySettings> findAllProxySettings(@Nonnull URI uRI) {
        return ProxySettingsManager.findAllProxySettings(uRI.getScheme(), uRI.getHost(), uRI.getPort());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IProxySettings> findAllProxySettings(@Nullable String string, @Nullable String string2, @CheckForSigned int n) {
        CommonsLinkedHashSet<IProxySettings> commonsLinkedHashSet = new CommonsLinkedHashSet<IProxySettings>();
        for (IProxySettingsProvider iProxySettingsProvider : ProxySettingsManager.getAllProviders()) {
            ICommonsList<IProxySettings> iCommonsList = iProxySettingsProvider.getAllProxySettings(string, string2, n);
            if (iCommonsList == null) continue;
            commonsLinkedHashSet.addAll(iCommonsList);
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    public static EHandled onConnectionFailed(@Nonnull URI uRI, @Nonnull SocketAddress socketAddress, @Nonnull IOException iOException) {
        String string = uRI.getScheme();
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        int n2 = 0;
        for (IProxySettingsProvider iProxySettingsProvider : ProxySettingsManager.getAllProviders()) {
            ICommonsList<IProxySettings> iCommonsList = iProxySettingsProvider.getAllProxySettings(string, string2, n);
            if (iCommonsList == null) continue;
            for (IProxySettings iProxySettings : iCommonsList) {
                if (!iProxySettings.hasSocketAddress(socketAddress)) continue;
                iProxySettingsProvider.onConnectionFailed(iProxySettings, uRI, socketAddress, iOException);
                ++n2;
            }
        }
        return EHandled.valueOf(n2 > 0);
    }
}

