/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.network.port.NetworkPortHelper;
import com.helger.network.proxy.config.EHttpProxyType;
import com.helger.network.proxy.config.HttpProxyAuthenticator;
import com.helger.network.proxy.config.IProxyConfig;
import com.helger.network.proxy.config.SocksProxyConfig;
import com.helger.network.proxy.config.UseSystemProxyConfig;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HttpProxyConfig
implements IProxyConfig {
    private final EHttpProxyType m_eProxyType;
    private final String m_sHost;
    private final int m_nPort;
    private final String m_sUserName;
    private final String m_sPassword;
    private final ICommonsList<String> m_aNonProxyHosts = new CommonsArrayList<String>();

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n) {
        this(eHttpProxyType, string, n, null, null, null);
    }

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n, @Nullable List<String> list) {
        this(eHttpProxyType, string, n, null, null, list);
    }

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n, @Nullable String string2, @Nullable String string3, @Nullable List<String> list) {
        ValueEnforcer.notNull(eHttpProxyType, "ProxyType");
        ValueEnforcer.notEmpty(string, "HostName");
        ValueEnforcer.isTrue(NetworkPortHelper.isValidPort(n), () -> "The passed port is invalid: " + n);
        this.m_eProxyType = eHttpProxyType;
        this.m_sHost = string;
        this.m_nPort = n;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        if (list != null) {
            for (String string4 : list) {
                if (!StringHelper.hasText(string4)) continue;
                this.m_aNonProxyHosts.add(string4);
            }
        }
    }

    @Nonnull
    public final EHttpProxyType getType() {
        return this.m_eProxyType;
    }

    @Nonnull
    public final String getHost() {
        return this.m_sHost;
    }

    @Nonnegative
    public final int getPort() {
        return this.m_nPort;
    }

    public boolean hasUserNameOrPassword() {
        return StringHelper.hasText(this.m_sUserName) || this.m_sPassword != null;
    }

    @Nullable
    public final String getUserName() {
        return this.m_sUserName;
    }

    @Nullable
    public final String getPassword() {
        return this.m_sPassword;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getNonProxyHosts() {
        return (ICommonsList)this.m_aNonProxyHosts.getClone();
    }

    @Nullable
    public Authenticator getAsAuthenticator() {
        if (StringHelper.hasNoText(this.m_eProxyType.getProxyUserName())) {
            return null;
        }
        return new HttpProxyAuthenticator(this.m_eProxyType);
    }

    @Override
    public void activateGlobally() {
        SocksProxyConfig.deactivateGlobally();
        UseSystemProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue(this.m_eProxyType.getPropertyNameProxyHost(), this.m_sHost);
        SystemProperties.setPropertyValue(this.m_eProxyType.getPropertyNameProxyPort(), Integer.toString(this.m_nPort));
        SystemProperties.setPropertyValue(this.m_eProxyType.getPropertyNameProxyUserName(), this.m_sUserName);
        SystemProperties.setPropertyValue(this.m_eProxyType.getPropertyNameProxyPassword(), this.m_sPassword);
        SystemProperties.setPropertyValue(this.m_eProxyType.getPropertyNameNoProxyHosts(), StringHelper.getImploded('|', this.m_aNonProxyHosts));
    }

    public static void deactivateGlobally() {
        for (EHttpProxyType eHttpProxyType : EHttpProxyType.values()) {
            SystemProperties.removePropertyValue(eHttpProxyType.getPropertyNameProxyHost());
            SystemProperties.removePropertyValue(eHttpProxyType.getPropertyNameProxyPort());
            SystemProperties.removePropertyValue(eHttpProxyType.getPropertyNameProxyUserName());
            SystemProperties.removePropertyValue(eHttpProxyType.getPropertyNameProxyPassword());
            SystemProperties.removePropertyValue(eHttpProxyType.getPropertyNameNoProxyHosts());
        }
    }

    @Nonnull
    public InetSocketAddress getAsInetSocketAddress() {
        return new InetSocketAddress(this.m_sHost, this.m_nPort);
    }

    @Override
    @Nonnull
    public Proxy getAsProxy() {
        return new Proxy(Proxy.Type.HTTP, this.getAsInetSocketAddress());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpProxyConfig httpProxyConfig = (HttpProxyConfig)object;
        return this.m_eProxyType.equals(httpProxyConfig.m_eProxyType) && this.m_sHost.equals(httpProxyConfig.m_sHost) && this.m_nPort == httpProxyConfig.m_nPort && EqualsHelper.equals(this.m_sUserName, httpProxyConfig.m_sUserName) && EqualsHelper.equals(this.m_sPassword, httpProxyConfig.m_sPassword) && EqualsHelper.equals(this.m_aNonProxyHosts, httpProxyConfig.m_aNonProxyHosts);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eProxyType)).append(this.m_sHost).append(this.m_nPort).append(this.m_sUserName).append(this.m_sPassword).append(this.m_aNonProxyHosts)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ProxyType", this.m_eProxyType).append("Host", this.m_sHost).append("Port", this.m_nPort).append("UserName", this.m_sUserName).appendPassword("Password").append("NonProxyHosts", this.m_aNonProxyHosts).getToString();
    }
}

