/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.network.port.ENetworkProtocol;
import com.helger.network.port.INetworkPort;
import com.helger.network.port.NetworkPortHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NetworkPort
implements INetworkPort {
    private final int m_nPort;
    private final ENetworkProtocol m_eProtocol;
    private final String m_sName;
    private final String m_sDescription;

    public NetworkPort(@Nonnegative int n, @Nonnull ENetworkProtocol eNetworkProtocol, @Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.isTrue(NetworkPortHelper.isValidPort(n), () -> "Port is illegal: " + n);
        this.m_nPort = n;
        this.m_eProtocol = ValueEnforcer.notNull(eNetworkProtocol, "Protocol");
        this.m_sName = ValueEnforcer.notNull(string, "Name");
        this.m_sDescription = ValueEnforcer.notNull(string2, "Description");
    }

    @Override
    @Nonnegative
    public int getPort() {
        return this.m_nPort;
    }

    @Override
    @Nonnull
    public ENetworkProtocol getProtocol() {
        return this.m_eProtocol;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.m_sDescription;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        NetworkPort networkPort = (NetworkPort)object;
        return this.m_nPort == networkPort.m_nPort && this.m_eProtocol.equals(networkPort.m_eProtocol) && this.m_sName.equals(networkPort.m_sName) && this.m_sDescription.equals(networkPort.m_sDescription);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_nPort).append((Enum)this.m_eProtocol)).append(this.m_sName).append(this.m_sDescription).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("port", this.m_nPort).append("protocol", this.m_eProtocol).append("name", this.m_sName).append("description", this.m_sDescription).getToString();
    }
}

