/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.authenticator;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConstantAuthenticator
extends Authenticator {
    public static final String DOMAIN_SEPARATOR = "\\";
    private final String m_sUserName;
    private final String m_sPassword;

    public ConstantAuthenticator(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        this(StringHelper.getConcatenatedOnDemand(string, DOMAIN_SEPARATOR, string2), string3);
    }

    public ConstantAuthenticator(@Nonnull String string, @Nonnull String string2) {
        this.m_sUserName = ValueEnforcer.notNull(string, "UserName");
        this.m_sPassword = ValueEnforcer.notNull(string2, "Password");
    }

    @Nonnull
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nonnull
    public String getPassword() {
        return this.m_sPassword;
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.m_sUserName, this.m_sPassword.toCharArray());
    }

    public String toString() {
        return new ToStringGenerator(this).append("UserName", this.m_sUserName).appendPassword("Password").getToString();
    }
}

