/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.visit;

import com.helger.commons.ValueEnforcer;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.visit.IJsonVisitorCallback;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonVisitor {
    private static final JsonVisitor s_aInstance = new JsonVisitor();

    private JsonVisitor() {
    }

    private static void _recursiveVisit(@Nonnull IJson iJson, @Nonnull IJsonVisitorCallback iJsonVisitorCallback) {
        if (iJson.isValue()) {
            iJsonVisitorCallback.onJsonValue((IJsonValue)iJson);
        } else if (iJson.isArray()) {
            IJsonArray iJsonArray = (IJsonArray)iJson;
            iJsonVisitorCallback.onJsonArrayStart(iJsonArray);
            for (IJson iJson2 : iJsonArray) {
                JsonVisitor._recursiveVisit(iJson2, iJsonVisitorCallback);
            }
            iJsonVisitorCallback.onJsonArrayEnd(iJsonArray);
        } else {
            IJsonObject iJsonObject = (IJsonObject)iJson;
            iJsonVisitorCallback.onJsonObjectStart(iJsonObject);
            for (Map.Entry entry : iJsonObject) {
                iJsonVisitorCallback.onJsonObjectElementName((String)entry.getKey());
                JsonVisitor._recursiveVisit((IJson)entry.getValue(), iJsonVisitorCallback);
            }
            iJsonVisitorCallback.onJsonObjectEnd(iJsonObject);
        }
    }

    public static void visit(@Nonnull IJson iJson, @Nonnull IJsonVisitorCallback iJsonVisitorCallback) {
        ValueEnforcer.notNull(iJson, "JSON");
        ValueEnforcer.notNull(iJsonVisitorCallback, "Callback");
        JsonVisitor._recursiveVisit(iJson, iJsonVisitorCallback);
    }
}

