/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsWeakHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.valueserializer.IJsonValueSerializer;
import com.helger.json.valueserializer.IJsonValueSerializerRegistrarSPI;
import com.helger.json.valueserializer.IJsonValueSerializerRegistry;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JsonValueSerializerRegistry
implements IJsonValueSerializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonValueSerializerRegistry.class);
    private static final JsonValueSerializerRegistry s_aInstance = new JsonValueSerializerRegistry();
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, IJsonValueSerializer> m_aMap = new CommonsWeakHashMap();

    private JsonValueSerializerRegistry() {
    }

    @Nonnull
    public static JsonValueSerializerRegistry getInstance() {
        return s_aInstance;
    }

    @Override
    public void registerJsonValueSerializer(@Nonnull Class<?> clazz, @Nonnull IJsonValueSerializer iJsonValueSerializer) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iJsonValueSerializer, "ValueSerializer");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("An IJsonValueSerializer for class " + clazz + " is already registered!");
            }
            this.m_aMap.put(clazz, iJsonValueSerializer);
        });
    }

    @Nullable
    public IJsonValueSerializer getJsonValueSerializer(@Nullable Class<?> clazz) {
        return this.m_aRWLock.readLockedGet(() -> (IJsonValueSerializer)this.m_aMap.get(clazz));
    }

    @Nonnegative
    public int getRegisteredJsonValueSerializerCount() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    public void reinitialize(@Nullable ClassLoader classLoader) {
        this.m_aRWLock.writeLocked(this.m_aMap::clear);
        for (IJsonValueSerializerRegistrarSPI iJsonValueSerializerRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IJsonValueSerializerRegistrarSPI.class, classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader())) {
            iJsonValueSerializerRegistrarSPI.registerJsonValueSerializer(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(s_aInstance.getRegisteredJsonValueSerializerCount() + " JSON value serializers registered");
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }

    static {
        s_aInstance.reinitialize(null);
    }
}

