/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.lang.ICloneable;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IJson
extends ICloneable<IJson>,
Serializable {
    public boolean isArray();

    @Nullable
    default public IJsonArray getAsArray() {
        return this.isArray() ? (IJsonArray)this : null;
    }

    public boolean isObject();

    @Nullable
    default public IJsonObject getAsObject() {
        return this.isObject() ? (IJsonObject)this : null;
    }

    public boolean isValue();

    @Nullable
    default public IJsonValue getAsValue() {
        return this.isValue() ? (IJsonValue)this : null;
    }

    @Nonnull
    default public String getAsJsonString() {
        return this.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS);
    }

    @Nonnull
    default public String getAsJsonString(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        return new JsonWriter(iJsonWriterSettings).writeAsString(this);
    }
}

