/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.list.ErrorList;
import com.helger.jaxb.IJAXBValidator;
import com.helger.jaxb.builder.AbstractWritingJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class JAXBValidationBuilder<JAXBTYPE, IMPLTYPE extends JAXBValidationBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE>
implements IJAXBValidator<JAXBTYPE> {
    public JAXBValidationBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        super(iJAXBDocumentType);
    }

    @Override
    public void validate(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull(JAXBTYPE, "JAXBDocument");
        ValueEnforcer.notNull(errorList, "ErrorList");
        if (!this.m_aDocType.getImplementationClass().getPackage().equals(JAXBTYPE.getClass().getPackage())) {
            throw new IllegalArgumentException("You cannot validate a '" + JAXBTYPE.getClass() + "' as a " + this.m_aDocType.getImplementationClass().getPackage().getName());
        }
        WrappedCollectingValidationEventHandler wrappedCollectingValidationEventHandler = new WrappedCollectingValidationEventHandler(errorList);
        try {
            Marshaller marshaller = this.createMarshaller();
            marshaller.setEventHandler(wrappedCollectingValidationEventHandler);
            Consumer<Marshaller> consumer = this.getMarshallerCustomizer();
            if (consumer != null) {
                consumer.accept(marshaller);
            }
            JAXBElement<JAXBTYPE> jAXBElement = this.createJAXBElement(JAXBTYPE);
            marshaller.marshal(jAXBElement, new DefaultHandler());
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }
}

