/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.LoggingJAXBReadExceptionHandler;
import com.helger.jaxb.builder.AbstractJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JAXBReaderBuilder<JAXBTYPE, IMPLTYPE extends JAXBReaderBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractJAXBBuilder<IMPLTYPE>
implements IJAXBReader<JAXBTYPE> {
    public static final boolean DEFAULT_READ_SECURE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBReaderBuilder.class);
    private final Class<JAXBTYPE> m_aImplClass;
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private Consumer<? super Unmarshaller> m_aUnmarshallerCustomizer;
    private boolean m_bReadSecure = true;

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        this(iJAXBDocumentType, (Class)GenericReflection.uncheckedCast(iJAXBDocumentType.getImplementationClass()));
    }

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType, @Nonnull Class<JAXBTYPE> clazz) {
        super(iJAXBDocumentType);
        this.m_aImplClass = ValueEnforcer.notNull(clazz, "ImplClass");
        this.exceptionCallbacks().add(new LoggingJAXBReadExceptionHandler());
    }

    @Nonnull
    protected final Class<JAXBTYPE> getImplClass() {
        return this.m_aImplClass;
    }

    @Nullable
    public final ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final IMPLTYPE setValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        this.m_aEventHandler = validationEventHandler;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nullable
    public final Consumer<? super Unmarshaller> getUnmarshallerCustomizer() {
        return this.m_aUnmarshallerCustomizer;
    }

    @Nonnull
    public final IMPLTYPE setUnmarshallerCustomizer(@Nullable Consumer<? super Unmarshaller> consumer) {
        this.m_aUnmarshallerCustomizer = consumer;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Override
    public final boolean isReadSecure() {
        return this.m_bReadSecure;
    }

    @Nonnull
    public final IMPLTYPE setReadSecure(boolean bl) {
        this.m_bReadSecure = bl;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nonnull
    protected Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.getJAXBContext();
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aEventHandler != null) {
            unmarshaller.setEventHandler(this.m_aEventHandler);
        } else {
            unmarshaller.setEventHandler(new LoggingValidationEventHandler().andThen(unmarshaller.getEventHandler()));
        }
        Schema schema2 = this.getSchema();
        if (schema2 != null) {
            unmarshaller.setSchema(schema2);
        }
        return unmarshaller;
    }

    @Override
    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBReader.IJAXBUnmarshaller<JAXBTYPE> iJAXBUnmarshaller) {
        ValueEnforcer.notNull(iJAXBUnmarshaller, "Handler");
        Schema schema2 = this.getSchema();
        if (schema2 == null && this.isUseSchema()) {
            LOGGER.warn("Don't know how to read JAXB document of type " + this.m_aImplClass.getName());
        }
        JAXBTYPE JAXBTYPE = null;
        try {
            JAXBElement<JAXBTYPE> jAXBElement;
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.m_aUnmarshallerCustomizer != null) {
                this.m_aUnmarshallerCustomizer.accept(unmarshaller);
            }
            if ((JAXBTYPE = (JAXBTYPE)(jAXBElement = iJAXBUnmarshaller.doUnmarshal(unmarshaller, this.m_aImplClass)).getValue()) == null) {
                throw new IllegalStateException("Failed to read JAXB document of class " + this.m_aImplClass.getName() + " - without exception!");
            }
        }
        catch (JAXBException jAXBException) {
            this.exceptionCallbacks().forEach((Consumer<IExceptionCallback<JAXBException>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(jAXBException)));
        }
        return JAXBTYPE;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("ImplClass", this.m_aImplClass).append("EventHandler", this.m_aEventHandler).append("UnmarshallerCustomizer", this.m_aUnmarshallerCustomizer).append("ReadSecure", this.m_bReadSecure).getToString();
    }
}

