/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.schema.IHasSchema;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

@MustImplementEqualsAndHashcode
public interface IJAXBDocumentType
extends IHasSchema,
Serializable {
    @Override
    public Schema getSchema();

    @Nonnull
    public Class<?> getImplementationClass();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources();

    @Nonnull
    public String getNamespaceURI();

    @Nonnull
    @Nonempty
    public String getLocalName();

    @Nullable
    default public Validator getValidator() {
        return this.getValidator(null);
    }

    @Nullable
    default public Validator getValidator(@Nullable Locale locale) {
        Validator validator;
        Schema schema2 = this.getSchema();
        if (schema2 != null && (validator = schema2.newValidator()) != null) {
            if (locale != null) {
                EXMLParserProperty.GENERAL_LOCALE.applyTo(validator, (Object)locale);
            }
            return validator;
        }
        return null;
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource) {
        Schema schema2 = this.getSchema();
        return schema2 == null ? null : XMLSchemaValidationHelper.validate(schema2, iReadableResource);
    }
}

