/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.security;

import com.helger.commons.ValueEnforcer;
import java.net.Socket;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyStrategyFromAliasCaseInsensitive
implements PrivateKeyStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyStrategyFromAliasCaseInsensitive.class);
    private final String m_sExpectedAlias;
    private boolean m_bWarnOnCaseDifference = false;

    public PrivateKeyStrategyFromAliasCaseInsensitive(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ExpectedAlias");
        this.m_sExpectedAlias = string;
    }

    @Nonnull
    public final String getExpectedAlias() {
        return this.m_sExpectedAlias;
    }

    public final boolean isWarnOnCaseDifference() {
        return this.m_bWarnOnCaseDifference;
    }

    public final void setWarnOnCaseDifference(boolean bl) {
        this.m_bWarnOnCaseDifference = bl;
    }

    @Override
    @Nullable
    public String chooseAlias(@Nonnull Map<String, PrivateKeyDetails> map, @Nullable Socket socket) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("chooseAlias(" + map + ", " + socket + ")");
        }
        for (String string : map.keySet()) {
            if (!string.equalsIgnoreCase(this.m_sExpectedAlias)) continue;
            if (string.equals(this.m_sExpectedAlias)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  Chose alias '" + string + "'");
                }
            } else if (this.m_bWarnOnCaseDifference && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Chose the keystore alias '" + string + "' but the configured alias '" + this.m_sExpectedAlias + "' has a different casing. It is recommended to adopt the expected alias accordingly.");
            }
            return string;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Found no certificate alias matching '" + this.m_sExpectedAlias + "' in the provided aliases " + map.keySet());
        }
        return null;
    }
}

