/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.IConsumer;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class ResponseHandlerString
implements ResponseHandler<String> {
    private final ContentType m_aDefault;
    private IConsumer<Charset> m_aCharsetConsumer;

    public ResponseHandlerString() {
        this(ContentType.DEFAULT_TEXT);
    }

    public ResponseHandlerString(@Nonnull ContentType contentType) {
        ValueEnforcer.notNull(contentType, "Default");
        ValueEnforcer.notNull(contentType.getCharset(), "DefaultContentType.Charset");
        this.m_aDefault = contentType;
    }

    @Nonnull
    public final ContentType getDefaultContentType() {
        return this.m_aDefault;
    }

    @Nonnull
    public final Charset getDefaultCharset() {
        return this.m_aDefault.getCharset();
    }

    @Nullable
    public final IConsumer<Charset> getCharsetConsumer() {
        return this.m_aCharsetConsumer;
    }

    @Nonnull
    public final ResponseHandlerString setCharsetConsumer(@Nullable IConsumer<Charset> iConsumer) {
        this.m_aCharsetConsumer = iConsumer;
        return this;
    }

    @Override
    @Nullable
    public String handleResponse(@Nonnull HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(httpResponse);
        if (httpEntity == null) {
            return null;
        }
        ContentType contentType = ContentType.get(httpEntity);
        if (contentType == null) {
            contentType = this.m_aDefault;
        }
        Charset charset = HttpClientHelper.getCharset(contentType, this.m_aDefault.getCharset());
        if (this.m_aCharsetConsumer != null) {
            this.m_aCharsetConsumer.accept(charset);
        }
        return EntityUtils.toString(httpEntity, charset);
    }
}

