/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerMicroDom
implements ResponseHandler<IMicroDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHandlerMicroDom.class);
    private final boolean m_bDebugMode;

    public ResponseHandlerMicroDom() {
        this(false);
    }

    public ResponseHandlerMicroDom(boolean bl) {
        this.m_bDebugMode = bl;
    }

    public final boolean isDebugMode() {
        return this.m_bDebugMode;
    }

    @Override
    @Nullable
    public IMicroDocument handleResponse(@Nonnull HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(httpResponse);
        if (httpEntity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        ContentType contentType = ContentType.getOrDefault(httpEntity);
        Charset charset = HttpClientHelper.getCharset(contentType);
        if (this.m_bDebugMode) {
            IMicroDocument iMicroDocument;
            String string = EntityUtils.toString(httpEntity, charset);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Got XML: <" + string + ">");
            }
            if ((iMicroDocument = MicroReader.readMicroXML(string)) == null) {
                throw new IllegalArgumentException("Failed to parse as XML: " + string);
            }
            return iMicroDocument;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent(), charset);
        return MicroReader.readMicroXML(inputStreamReader);
    }
}

